/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.internal.platform.Platform;
import okio.GzipSource;
import okio.Okio;

public final class PublicSuffixDatabase {
    public static final String PUBLIC_SUFFIX_RESOURCE = "publicsuffixes.gz";
    private static final byte[] WILDCARD_LABEL = new byte[]{42};
    private static final String[] EMPTY_RULE = new String[0];
    private static final String[] PREVAILING_RULE = new String[]{"*"};
    private static final byte EXCEPTION_MARKER = 33;
    private static final PublicSuffixDatabase instance = new PublicSuffixDatabase();
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;

    public static PublicSuffixDatabase get() {
        return instance;
    }

    public String getEffectiveTldPlusOne(String string) {
        String[] stringArray;
        if (string == null) {
            throw new NullPointerException("domain == null");
        }
        String string2 = IDN.toUnicode(string);
        String[] stringArray2 = string2.split("\\.");
        if (stringArray2.length == (stringArray = this.findMatchingRule(stringArray2)).length && stringArray[0].charAt(0) != '!') {
            return null;
        }
        int n = stringArray[0].charAt(0) == '!' ? stringArray2.length - stringArray.length : stringArray2.length - (stringArray.length + 1);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray3 = string.split("\\.");
        for (int i = n; i < stringArray3.length; ++i) {
            stringBuilder.append(stringArray3[i]).append('.');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findMatchingRule(String[] stringArray) {
        Object object;
        int n;
        Object object2;
        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
            this.readTheListUninterruptibly();
        } else {
            try {
                this.readCompleteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        Object object3 = this;
        synchronized (object3) {
            if (this.publicSuffixListBytes == null) {
                throw new IllegalStateException("Unable to load publicsuffixes.gz resource from the classpath.");
            }
        }
        object3 = new byte[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            object3[i] = stringArray[i].getBytes(StandardCharsets.UTF_8);
        }
        String string = null;
        for (int i = 0; i < ((Object)object3).length; ++i) {
            object2 = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, (byte[][])object3, i);
            if (object2 == null) continue;
            string = object2;
            break;
        }
        Object object4 = null;
        if (((Object)object3).length > 1) {
            object2 = (byte[][])object3.clone();
            for (n = 0; n < ((Object)object2).length - 1; ++n) {
                object2[n] = WILDCARD_LABEL;
                object = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, (byte[][])object2, n);
                if (object == null) continue;
                object4 = object;
                break;
            }
        }
        object2 = null;
        if (object4 != null) {
            for (n = 0; n < ((Object)object3).length - 1; ++n) {
                object = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixExceptionListBytes, (byte[][])object3, n);
                if (object == null) continue;
                object2 = object;
                break;
            }
        }
        if (object2 != null) {
            object2 = "!" + (String)object2;
            return object2.split("\\.");
        }
        if (string == null && object4 == null) {
            return PREVAILING_RULE;
        }
        String[] stringArray2 = string != null ? string.split("\\.") : EMPTY_RULE;
        object = object4 != null ? object4.split("\\.") : EMPTY_RULE;
        return stringArray2.length > ((String[])object).length ? stringArray2 : object;
    }

    private static String binarySearchBytes(byte[] byArray, byte[][] byArray2, int n) {
        int n2 = 0;
        int n3 = byArray.length;
        String string = null;
        while (n2 < n3) {
            int n4;
            int n5;
            int n6;
            int n7;
            for (n7 = (n2 + n3) / 2; n7 > -1 && byArray[n7] != 10; --n7) {
            }
            ++n7;
            int n8 = 1;
            while (byArray[n7 + n8] != 10) {
                ++n8;
            }
            int n9 = n7 + n8 - n7;
            int n10 = n;
            int n11 = 0;
            int n12 = 0;
            boolean bl = false;
            while (true) {
                if (bl) {
                    n6 = 46;
                    bl = false;
                } else {
                    n6 = byArray2[n10][n11] & 0xFF;
                }
                n5 = byArray[n7 + n12] & 0xFF;
                n4 = n6 - n5;
                if (n4 != 0) break;
                ++n11;
                if (++n12 == n9) break;
                if (byArray2[n10].length != n11) continue;
                if (n10 == byArray2.length - 1) break;
                ++n10;
                n11 = -1;
                bl = true;
            }
            if (n4 < 0) {
                n3 = n7 - 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n7 + n8 + 1;
                continue;
            }
            n6 = n9 - n12;
            n5 = byArray2[n10].length - n11;
            for (int i = n10 + 1; i < byArray2.length; ++i) {
                n5 += byArray2[i].length;
            }
            if (n5 < n6) {
                n3 = n7 - 1;
                continue;
            }
            if (n5 > n6) {
                n2 = n7 + n8 + 1;
                continue;
            }
            string = new String(byArray, n7, n9, StandardCharsets.UTF_8);
            break;
        }
        return string;
    }

    private void readTheListUninterruptibly() {
        boolean bl = false;
        while (true) {
            try {
                this.readTheList();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.interrupted();
                bl = true;
                continue;
            }
            catch (IOException iOException) {
                Platform.get().log(5, "Failed to read public suffix list", iOException);
                return;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTheList() throws IOException {
        byte[] byArray;
        byte[] byArray2;
        InputStream inputStream = PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE);
        if (inputStream == null) {
            return;
        }
        try (Object object = Okio.buffer(new GzipSource(Okio.source(inputStream)));){
            int n = object.readInt();
            byArray2 = new byte[n];
            object.readFully(byArray2);
            int n2 = object.readInt();
            byArray = new byte[n2];
            object.readFully(byArray);
        }
        object = this;
        synchronized (object) {
            this.publicSuffixListBytes = byArray2;
            this.publicSuffixExceptionListBytes = byArray;
        }
        this.readCompleteLatch.countDown();
    }

    void setListBytes(byte[] byArray, byte[] byArray2) {
        this.publicSuffixListBytes = byArray;
        this.publicSuffixExceptionListBytes = byArray2;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }
}

