/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Android10Platform;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.ConscryptPlatform;
import okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import okhttp3.internal.platform.Jdk9Platform;
import okhttp3.internal.tls.BasicCertificateChainCleaner;
import okhttp3.internal.tls.BasicTrustRootIndex;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import okio.Buffer;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    public static final int INFO = 4;
    public static final int WARN = 5;
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    @Nullable
    protected X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        try {
            Class<?> clazz = Class.forName("sun.security.ssl.SSLContextImpl");
            Object obj = Platform.readFieldOrNull(sSLSocketFactory, clazz, "context");
            if (obj == null) {
                return null;
            }
            return Platform.readFieldOrNull(obj, X509TrustManager.class, "trustManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, @Nullable String string, List<Protocol> list) throws IOException {
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) throws IOException {
        socket.connect(inetSocketAddress, n);
    }

    public void log(int n, String string, @Nullable Throwable throwable) {
        Level level = n == 5 ? Level.WARNING : Level.INFO;
        logger.log(level, string, throwable);
    }

    public boolean isCleartextTrafficPermitted(String string) {
        return true;
    }

    @Nullable
    public Object getStackTraceForCloseable(String string) {
        if (logger.isLoggable(Level.FINE)) {
            return new Throwable(string);
        }
        return null;
    }

    public void logCloseableLeak(String string, Object object) {
        if (object == null) {
            string = string + " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);";
        }
        this.log(5, string, (Throwable)object);
    }

    public static List<String> alpnProtocolNames(List<Protocol> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Protocol protocol = list.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            arrayList.add(protocol.toString());
        }
        return arrayList;
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    public CertificateChainCleaner buildCertificateChainCleaner(SSLSocketFactory sSLSocketFactory) {
        X509TrustManager x509TrustManager = this.trustManager(sSLSocketFactory);
        if (x509TrustManager == null) {
            throw new IllegalStateException("Unable to extract the trust manager on " + Platform.get() + ", sslSocketFactory is " + sSLSocketFactory.getClass());
        }
        return this.buildCertificateChainCleaner(x509TrustManager);
    }

    public static boolean isConscryptPreferred() {
        if ("conscrypt".equals(Util.getSystemProperty("okhttp.platform", null))) {
            return true;
        }
        String string = Security.getProviders()[0].getName();
        return "Conscrypt".equals(string);
    }

    private static Platform findPlatform() {
        if (Platform.isAndroid()) {
            return Platform.findAndroidPlatform();
        }
        return Platform.findJvmPlatform();
    }

    public static boolean isAndroid() {
        return "Dalvik".equals(System.getProperty("java.vm.name"));
    }

    private static Platform findJvmPlatform() {
        Platform platform;
        if (Platform.isConscryptPreferred() && (platform = ConscryptPlatform.buildIfSupported()) != null) {
            return platform;
        }
        platform = Jdk9Platform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        Platform platform2 = Jdk8WithJettyBootPlatform.buildIfSupported();
        if (platform2 != null) {
            return platform2;
        }
        return new Platform();
    }

    private static Platform findAndroidPlatform() {
        Platform platform = Android10Platform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        Platform platform2 = AndroidPlatform.buildIfSupported();
        if (platform2 == null) {
            throw new NullPointerException("No platform found on Android");
        }
        return platform2;
    }

    static byte[] concatLengthPrefixed(List<Protocol> list) {
        Buffer buffer = new Buffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Protocol protocol = list.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            buffer.writeByte(protocol.toString().length());
            buffer.writeUtf8(protocol.toString());
        }
        return buffer.readByteArray();
    }

    @Nullable
    static <T> T readFieldOrNull(Object object, Class<T> clazz, String string) {
        Object object2;
        for (object2 = object.getClass(); object2 != Object.class; object2 = ((Class)object2).getSuperclass()) {
            try {
                Field field = ((Class)object2).getDeclaredField(string);
                field.setAccessible(true);
                Object object3 = field.get(object);
                if (!clazz.isInstance(object3)) {
                    return null;
                }
                return clazz.cast(object3);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
        if (!string.equals("delegate") && (object2 = Platform.readFieldOrNull(object, Object.class, "delegate")) != null) {
            return Platform.readFieldOrNull(object2, clazz, string);
        }
        return null;
    }

    public SSLContext getSSLContext() {
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        return new BasicTrustRootIndex(x509TrustManager.getAcceptedIssuers());
    }

    public void configureSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

