/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;

class Jdk8WithJettyBootPlatform
extends Platform {
    private final Method putMethod;
    private final Method getMethod;
    private final Method removeMethod;
    private final Class<?> clientProviderClass;
    private final Class<?> serverProviderClass;

    Jdk8WithJettyBootPlatform(Method method, Method method2, Method method3, Class<?> clazz, Class<?> clazz2) {
        this.putMethod = method;
        this.getMethod = method2;
        this.removeMethod = method3;
        this.clientProviderClass = clazz;
        this.serverProviderClass = clazz2;
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) {
        List<String> list2 = Jdk8WithJettyBootPlatform.alpnProtocolNames(list);
        try {
            Object object = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new AlpnProvider(list2));
            this.putMethod.invoke(null, sSLSocket, object);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError("failed to set ALPN", reflectiveOperationException);
        }
    }

    @Override
    public void afterHandshake(SSLSocket sSLSocket) {
        try {
            this.removeMethod.invoke(null, sSLSocket);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError("failed to remove ALPN", reflectiveOperationException);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        try {
            AlpnProvider alpnProvider = (AlpnProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, sSLSocket));
            if (!alpnProvider.unsupported && alpnProvider.selected == null) {
                Platform.get().log(4, "ALPN callback dropped: HTTP/2 is disabled. Is alpn-boot on the boot class path?", null);
                return null;
            }
            return alpnProvider.unsupported ? null : alpnProvider.selected;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError("failed to get ALPN selected protocol", reflectiveOperationException);
        }
    }

    public static Platform buildIfSupported() {
        try {
            String string = "org.eclipse.jetty.alpn.ALPN";
            Class<?> clazz = Class.forName(string, true, null);
            Class<?> clazz2 = Class.forName(string + "$Provider", true, null);
            Class<?> clazz3 = Class.forName(string + "$ClientProvider", true, null);
            Class<?> clazz4 = Class.forName(string + "$ServerProvider", true, null);
            Method method = clazz.getMethod("put", SSLSocket.class, clazz2);
            Method method2 = clazz.getMethod("get", SSLSocket.class);
            Method method3 = clazz.getMethod("remove", SSLSocket.class);
            return new Jdk8WithJettyBootPlatform(method, method2, method3, clazz3, clazz4);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }

    private static class AlpnProvider
    implements InvocationHandler {
        private final List<String> protocols;
        boolean unsupported;
        String selected;

        AlpnProvider(List<String> list) {
            this.protocols = list;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            Class<?> clazz = method.getReturnType();
            if (objectArray == null) {
                objectArray = Util.EMPTY_STRING_ARRAY;
            }
            if (string.equals("supports") && Boolean.TYPE == clazz) {
                return true;
            }
            if (string.equals("unsupported") && Void.TYPE == clazz) {
                this.unsupported = true;
                return null;
            }
            if (string.equals("protocols") && objectArray.length == 0) {
                return this.protocols;
            }
            if ((string.equals("selectProtocol") || string.equals("select")) && String.class == clazz && objectArray.length == 1 && objectArray[0] instanceof List) {
                List list = (List)objectArray[0];
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)list.get(i);
                    if (!this.protocols.contains(string2)) continue;
                    this.selected = string2;
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((string.equals("protocolSelected") || string.equals("selected")) && objectArray.length == 1) {
                this.selected = (String)objectArray[0];
                return null;
            }
            return method.invoke((Object)this, objectArray);
        }
    }
}

