/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import org.conscrypt.Conscrypt;

public class ConscryptPlatform
extends Platform {
    private ConscryptPlatform() {
    }

    private Provider getProvider() {
        return Conscrypt.newProviderBuilder().provideTrustManager().build();
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        if (!Conscrypt.isConscrypt((SSLSocketFactory)sSLSocketFactory)) {
            return super.trustManager(sSLSocketFactory);
        }
        try {
            Object object = ConscryptPlatform.readFieldOrNull(sSLSocketFactory, Object.class, "sslParameters");
            if (object != null) {
                return ConscryptPlatform.readFieldOrNull(object, X509TrustManager.class, "x509TrustManager");
            }
            return null;
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported on Conscrypt", exception);
        }
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) throws IOException {
        if (Conscrypt.isConscrypt((SSLSocket)sSLSocket)) {
            if (string != null) {
                Conscrypt.setUseSessionTickets((SSLSocket)sSLSocket, (boolean)true);
                Conscrypt.setHostname((SSLSocket)sSLSocket, (String)string);
            }
            List<String> list2 = Platform.alpnProtocolNames(list);
            Conscrypt.setApplicationProtocols((SSLSocket)sSLSocket, (String[])list2.toArray(new String[0]));
        } else {
            super.configureTlsExtensions(sSLSocket, string, list);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        if (Conscrypt.isConscrypt((SSLSocket)sSLSocket)) {
            return Conscrypt.getApplicationProtocol((SSLSocket)sSLSocket);
        }
        return super.getSelectedProtocol(sSLSocket);
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            return SSLContext.getInstance("TLSv1.3", this.getProvider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                return SSLContext.getInstance("TLS", this.getProvider());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
            }
        }
    }

    public static ConscryptPlatform buildIfSupported() {
        try {
            Class.forName("org.conscrypt.Conscrypt");
            if (!Conscrypt.isAvailable()) {
                return null;
            }
            return new ConscryptPlatform();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public void configureSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (Conscrypt.isConscrypt((SSLSocketFactory)sSLSocketFactory)) {
            Conscrypt.setUseEngineSocket((SSLSocketFactory)sSLSocketFactory, (boolean)true);
        }
    }
}

