/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final Class<?> sslSocketClass;
    private final Method setUseSessionTickets;
    private final Method setHostname;
    private final Method getAlpnSelectedProtocol;
    private final Method setAlpnProtocols;
    private final CloseGuard closeGuard = CloseGuard.get();

    AndroidPlatform(Class<?> clazz, Class<?> clazz2, Method method, Method method2, Method method3, Method method4) {
        this.sslParametersClass = clazz;
        this.sslSocketClass = clazz2;
        this.setUseSessionTickets = method;
        this.setHostname = method2;
        this.getAlpnSelectedProtocol = method3;
        this.setAlpnProtocols = method4;
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) throws IOException {
        try {
            socket.connect(inetSocketAddress, n);
        }
        catch (AssertionError assertionError) {
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)((Object)assertionError));
            }
            throw assertionError;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", classCastException);
            }
            throw classCastException;
        }
    }

    @Override
    @Nullable
    protected X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        Object object;
        Object object2 = AndroidPlatform.readFieldOrNull(sSLSocketFactory, this.sslParametersClass, "sslParameters");
        if (object2 == null) {
            try {
                object = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sSLSocketFactory.getClass().getClassLoader());
                object2 = AndroidPlatform.readFieldOrNull(sSLSocketFactory, object, "sslParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.trustManager(sSLSocketFactory);
            }
        }
        if ((object = AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, "x509TrustManager")) != null) {
            return object;
        }
        return AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) throws IOException {
        if (!this.sslSocketClass.isInstance(sSLSocket)) {
            return;
        }
        try {
            if (string != null) {
                this.setUseSessionTickets.invoke((Object)sSLSocket, true);
                this.setHostname.invoke((Object)sSLSocket, string);
            }
            this.setAlpnProtocols.invoke((Object)sSLSocket, new Object[]{AndroidPlatform.concatLengthPrefixed(list)});
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        if (!this.sslSocketClass.isInstance(sSLSocket)) {
            return null;
        }
        try {
            byte[] byArray = (byte[])this.getAlpnSelectedProtocol.invoke((Object)sSLSocket, new Object[0]);
            return byArray != null ? new String(byArray, StandardCharsets.UTF_8) : null;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    @Override
    public void log(int n, String string, @Nullable Throwable throwable) {
        int n2;
        int n3 = n2 = n == 5 ? 5 : 3;
        if (throwable != null) {
            string = string + '\n' + Log.getStackTraceString((Throwable)throwable);
        }
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6 = string.indexOf(10, i);
            n6 = n6 != -1 ? n6 : n4;
            do {
                n5 = Math.min(n6, i + 4000);
                Log.println((int)n2, (String)"OkHttp", (String)string.substring(i, n5));
            } while ((i = n5) < n6);
        }
    }

    @Override
    @Nullable
    public Object getStackTraceForCloseable(String string) {
        return this.closeGuard.createAndOpen(string);
    }

    @Override
    public void logCloseableLeak(String string, Object object) {
        boolean bl = this.closeGuard.warnIfOpen(object);
        if (!bl) {
            this.log(5, string, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(String string) {
        try {
            Class<?> clazz = Class.forName("android.security.NetworkSecurityPolicy");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            return this.api24IsCleartextTrafficPermitted(string, clazz, object);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return super.isCleartextTrafficPermitted(string);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new AssertionError("unable to determine cleartext support", exception);
        }
    }

    private boolean api24IsCleartextTrafficPermitted(String string, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            Method method = clazz.getMethod("isCleartextTrafficPermitted", String.class);
            return (Boolean)method.invoke(object, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.api23IsCleartextTrafficPermitted(string, clazz, object);
        }
    }

    private boolean api23IsCleartextTrafficPermitted(String string, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            Method method = clazz.getMethod("isCleartextTrafficPermitted", new Class[0]);
            return (Boolean)method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(string);
        }
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        try {
            Class<?> clazz = Class.forName("android.net.http.X509TrustManagerExtensions");
            Constructor<?> constructor = clazz.getConstructor(X509TrustManager.class);
            Object obj = constructor.newInstance(x509TrustManager);
            Method method = clazz.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
            return new AndroidCertificateChainCleaner(obj, method);
        }
        catch (Exception exception) {
            return super.buildCertificateChainCleaner(x509TrustManager);
        }
    }

    @Nullable
    public static Platform buildIfSupported() {
        Class<?> clazz;
        Class<?> clazz2;
        if (!Platform.isAndroid()) {
            return null;
        }
        try {
            clazz2 = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            clazz = Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Method method = clazz.getDeclaredMethod("setUseSessionTickets", Boolean.TYPE);
                Method method2 = clazz.getMethod("setHostname", String.class);
                Method method3 = clazz.getMethod("getAlpnSelectedProtocol", new Class[0]);
                Method method4 = clazz.getMethod("setAlpnProtocols", byte[].class);
                return new AndroidPlatform(clazz2, clazz, method, method2, method3, method4);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Expected Android API level 21+ but was " + Build.VERSION.SDK_INT);
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        try {
            Method method = x509TrustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
            method.setAccessible(true);
            return new CustomTrustRootIndex(x509TrustManager, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(x509TrustManager);
        }
    }

    @Override
    public SSLContext getSSLContext() {
        boolean bl;
        try {
            bl = Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 22;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = true;
        }
        if (bl) {
            try {
                return SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    static int getSdkInt() {
        try {
            return Build.VERSION.SDK_INT;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return 0;
        }
    }

    static final class CustomTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;

        CustomTrustRootIndex(X509TrustManager x509TrustManager, Method method) {
            this.findByIssuerAndSignatureMethod = method;
            this.trustManager = x509TrustManager;
        }

        @Override
        public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
            try {
                TrustAnchor trustAnchor = (TrustAnchor)this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, x509Certificate);
                return trustAnchor != null ? trustAnchor.getTrustedCert() : null;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError("unable to get issues and signature", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CustomTrustRootIndex)) {
                return false;
            }
            CustomTrustRootIndex customTrustRootIndex = (CustomTrustRootIndex)object;
            return this.trustManager.equals(customTrustRootIndex.trustManager) && this.findByIssuerAndSignatureMethod.equals(customTrustRootIndex.findByIssuerAndSignatureMethod);
        }

        public int hashCode() {
            return this.trustManager.hashCode() + 31 * this.findByIssuerAndSignatureMethod.hashCode();
        }
    }

    static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;

        CloseGuard(Method method, Method method2, Method method3) {
            this.getMethod = method;
            this.openMethod = method2;
            this.warnIfOpenMethod = method3;
        }

        Object createAndOpen(String string) {
            if (this.getMethod != null) {
                try {
                    Object object = this.getMethod.invoke(null, new Object[0]);
                    this.openMethod.invoke(object, string);
                    return object;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        boolean warnIfOpen(Object object) {
            boolean bl = false;
            if (object != null) {
                try {
                    this.warnIfOpenMethod.invoke(object, new Object[0]);
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }

        static CloseGuard get() {
            Method method;
            Method method2;
            Method method3;
            try {
                Class<?> clazz = Class.forName("dalvik.system.CloseGuard");
                method3 = clazz.getMethod("get", new Class[0]);
                method2 = clazz.getMethod("open", String.class);
                method = clazz.getMethod("warnIfOpen", new Class[0]);
            }
            catch (Exception exception) {
                method3 = null;
                method2 = null;
                method = null;
            }
            return new CloseGuard(method3, method2, method);
        }
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;

        AndroidCertificateChainCleaner(Object object, Method method) {
            this.x509TrustManagerExtensions = object;
            this.checkServerTrusted = method;
        }

        @Override
        public List<Certificate> clean(List<Certificate> list, String string) throws SSLPeerUnverifiedException {
            try {
                X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[list.size()]);
                return (List)this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, x509CertificateArray, "RSA", string);
            }
            catch (InvocationTargetException invocationTargetException) {
                SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(invocationTargetException.getMessage());
                sSLPeerUnverifiedException.initCause(invocationTargetException);
                throw sSLPeerUnverifiedException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        public boolean equals(Object object) {
            return object instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }
    }
}

