/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.annotation.SuppressLint;
import android.net.ssl.SSLSockets;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import okhttp3.Protocol;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.Platform;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@SuppressLint(value={"NewApi"})
class Android10Platform
extends AndroidPlatform {
    Android10Platform(Class<?> clazz) {
        super(clazz, null, null, null, null, null);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    @IgnoreJRERequirement
    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) throws IOException {
        try {
            this.enableSessionTickets(sSLSocket);
            SSLParameters sSLParameters = sSLSocket.getSSLParameters();
            String[] stringArray = Platform.alpnProtocolNames(list).toArray(new String[0]);
            sSLParameters.setApplicationProtocols(stringArray);
            sSLSocket.setSSLParameters(sSLParameters);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Android internal error", illegalArgumentException);
        }
    }

    private void enableSessionTickets(SSLSocket sSLSocket) {
        if (SSLSockets.isSupportedSocket((SSLSocket)sSLSocket)) {
            SSLSockets.setUseSessionTickets((SSLSocket)sSLSocket, (boolean)true);
        }
    }

    @Override
    @Nullable
    @IgnoreJRERequirement
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        String string = sSLSocket.getApplicationProtocol();
        if (string == null || string.isEmpty()) {
            return null;
        }
        return string;
    }

    @Nullable
    public static Platform buildIfSupported() {
        if (!Platform.isAndroid()) {
            return null;
        }
        try {
            if (Android10Platform.getSdkInt() >= 29) {
                Class<?> clazz = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
                return new Android10Platform(clazz);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

