/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.util.Arrays;

public final class Settings {
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    static final int HEADER_TABLE_SIZE = 1;
    static final int ENABLE_PUSH = 2;
    static final int MAX_CONCURRENT_STREAMS = 4;
    static final int MAX_FRAME_SIZE = 5;
    static final int MAX_HEADER_LIST_SIZE = 6;
    static final int INITIAL_WINDOW_SIZE = 7;
    static final int COUNT = 10;
    private int set;
    private final int[] values = new int[10];

    void clear() {
        this.set = 0;
        Arrays.fill(this.values, 0);
    }

    Settings set(int n, int n2) {
        if (n < 0 || n >= this.values.length) {
            return this;
        }
        int n3 = 1 << n;
        this.set |= n3;
        this.values[n] = n2;
        return this;
    }

    boolean isSet(int n) {
        int n2 = 1 << n;
        return (this.set & n2) != 0;
    }

    int get(int n) {
        return this.values[n];
    }

    int size() {
        return Integer.bitCount(this.set);
    }

    int getHeaderTableSize() {
        int n = 2;
        return (n & this.set) != 0 ? this.values[1] : -1;
    }

    boolean getEnablePush(boolean bl) {
        int n = 4;
        return ((n & this.set) != 0 ? this.values[2] : (bl ? 1 : 0)) == 1;
    }

    int getMaxConcurrentStreams(int n) {
        int n2 = 16;
        return (n2 & this.set) != 0 ? this.values[4] : n;
    }

    int getMaxFrameSize(int n) {
        int n2 = 32;
        return (n2 & this.set) != 0 ? this.values[5] : n;
    }

    int getMaxHeaderListSize(int n) {
        int n2 = 64;
        return (n2 & this.set) != 0 ? this.values[6] : n;
    }

    int getInitialWindowSize() {
        int n = 128;
        return (n & this.set) != 0 ? this.values[7] : 65535;
    }

    void merge(Settings settings) {
        for (int i = 0; i < 10; ++i) {
            if (!settings.isSet(i)) continue;
            this.set(i, settings.get(i));
        }
    }
}

