/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSink;

final class Http2Writer
implements Closeable {
    private static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSink sink;
    private final boolean client;
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    final Hpack.Writer hpackWriter;

    Http2Writer(BufferedSink bufferedSink, boolean bl) {
        this.sink = bufferedSink;
        this.client = bl;
        this.hpackBuffer = new Buffer();
        this.hpackWriter = new Hpack.Writer(this.hpackBuffer);
        this.maxFrameSize = 16384;
    }

    public synchronized void connectionPreface() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!this.client) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Util.format(">> CONNECTION %s", Http2.CONNECTION_PREFACE.hex()));
        }
        this.sink.write(Http2.CONNECTION_PREFACE.toByteArray());
        this.sink.flush();
    }

    public synchronized void applyAndAckSettings(Settings settings) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.maxFrameSize = settings.getMaxFrameSize(this.maxFrameSize);
        if (settings.getHeaderTableSize() != -1) {
            this.hpackWriter.setHeaderTableSizeSetting(settings.getHeaderTableSize());
        }
        int n = 0;
        byte by = 4;
        byte by2 = 1;
        int n2 = 0;
        this.frameHeader(n2, n, by, by2);
        this.sink.flush();
    }

    public synchronized void pushPromise(int n, int n2, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(list);
        long l = this.hpackBuffer.size();
        int n3 = (int)Math.min((long)(this.maxFrameSize - 4), l);
        byte by = 5;
        byte by2 = l == (long)n3 ? (byte)4 : 0;
        this.frameHeader(n, n3 + 4, by, by2);
        this.sink.writeInt(n2 & Integer.MAX_VALUE);
        this.sink.write(this.hpackBuffer, (long)n3);
        if (l > (long)n3) {
            this.writeContinuationFrames(n, l - (long)n3);
        }
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.sink.flush();
    }

    public synchronized void rstStream(int n, ErrorCode errorCode) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.httpCode == -1) {
            throw new IllegalArgumentException();
        }
        int n2 = 4;
        byte by = 3;
        byte by2 = 0;
        this.frameHeader(n, n2, by, by2);
        this.sink.writeInt(errorCode.httpCode);
        this.sink.flush();
    }

    public int maxDataLength() {
        return this.maxFrameSize;
    }

    public synchronized void data(boolean bl, int n, Buffer buffer, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        byte by = 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        this.dataFrame(n, by, buffer, n2);
    }

    void dataFrame(int n, byte by, Buffer buffer, int n2) throws IOException {
        byte by2 = 0;
        this.frameHeader(n, n2, by2, by);
        if (n2 > 0) {
            this.sink.write(buffer, (long)n2);
        }
    }

    public synchronized void settings(Settings settings) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n = settings.size() * 6;
        byte by = 4;
        byte by2 = 0;
        int n2 = 0;
        this.frameHeader(n2, n, by, by2);
        for (int i = 0; i < 10; ++i) {
            if (!settings.isSet(i)) continue;
            int n3 = i;
            if (n3 == 4) {
                n3 = 3;
            } else if (n3 == 7) {
                n3 = 4;
            }
            this.sink.writeShort(n3);
            this.sink.writeInt(settings.get(i));
        }
        this.sink.flush();
    }

    public synchronized void ping(boolean bl, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n3 = 8;
        byte by = 6;
        byte by2 = bl ? (byte)1 : 0;
        int n4 = 0;
        this.frameHeader(n4, n3, by, by2);
        this.sink.writeInt(n);
        this.sink.writeInt(n2);
        this.sink.flush();
    }

    public synchronized void goAway(int n, ErrorCode errorCode, byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.httpCode == -1) {
            throw Http2.illegalArgument("errorCode.httpCode == -1", new Object[0]);
        }
        int n2 = 8 + byArray.length;
        byte by = 7;
        byte by2 = 0;
        int n3 = 0;
        this.frameHeader(n3, n2, by, by2);
        this.sink.writeInt(n);
        this.sink.writeInt(errorCode.httpCode);
        if (byArray.length > 0) {
            this.sink.write(byArray);
        }
        this.sink.flush();
    }

    public synchronized void windowUpdate(int n, long l) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (l == 0L || l > Integer.MAX_VALUE) {
            throw Http2.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", l);
        }
        int n2 = 4;
        byte by = 8;
        byte by2 = 0;
        this.frameHeader(n, n2, by, by2);
        this.sink.writeInt((int)l);
        this.sink.flush();
    }

    public void frameHeader(int n, int n2, byte by, byte by2) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(false, n, n2, by, by2));
        }
        if (n2 > this.maxFrameSize) {
            throw Http2.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", this.maxFrameSize, n2);
        }
        if ((n & Integer.MIN_VALUE) != 0) {
            throw Http2.illegalArgument("reserved bit set: %s", n);
        }
        Http2Writer.writeMedium(this.sink, n2);
        this.sink.writeByte(by & 0xFF);
        this.sink.writeByte(by2 & 0xFF);
        this.sink.writeInt(n & Integer.MAX_VALUE);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    private static void writeMedium(BufferedSink bufferedSink, int n) throws IOException {
        bufferedSink.writeByte(n >>> 16 & 0xFF);
        bufferedSink.writeByte(n >>> 8 & 0xFF);
        bufferedSink.writeByte(n & 0xFF);
    }

    private void writeContinuationFrames(int n, long l) throws IOException {
        while (l > 0L) {
            int n2;
            this.frameHeader(n, n2, (byte)9, (l -= (long)(n2 = (int)Math.min((long)this.maxFrameSize, l))) == 0L ? (byte)4 : 0);
            this.sink.write(this.hpackBuffer, (long)n2);
        }
    }

    public synchronized void headers(boolean bl, int n, List<Header> list) throws IOException {
        byte by;
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(list);
        long l = this.hpackBuffer.size();
        int n2 = (int)Math.min((long)this.maxFrameSize, l);
        byte by2 = 1;
        byte by3 = by = l == (long)n2 ? (byte)4 : 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        this.frameHeader(n, n2, by2, by);
        this.sink.write(this.hpackBuffer, (long)n2);
        if (l > (long)n2) {
            this.writeContinuationFrames(n, l - (long)n2);
        }
    }
}

