/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.StreamResetException;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Http2Stream {
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    final int id;
    final Http2Connection connection;
    private final Deque<Headers> headersQueue = new ArrayDeque<Headers>();
    private boolean hasResponseHeaders;
    private final FramingSource source;
    final FramingSink sink;
    final StreamTimeout readTimeout = new StreamTimeout();
    final StreamTimeout writeTimeout = new StreamTimeout();
    @Nullable
    ErrorCode errorCode;
    @Nullable
    IOException errorException;

    Http2Stream(int n, Http2Connection http2Connection, boolean bl, boolean bl2, @Nullable Headers headers) {
        if (http2Connection == null) {
            throw new NullPointerException("connection == null");
        }
        this.id = n;
        this.connection = http2Connection;
        this.bytesLeftInWriteWindow = http2Connection.peerSettings.getInitialWindowSize();
        this.source = new FramingSource(http2Connection.okHttpSettings.getInitialWindowSize());
        this.sink = new FramingSink();
        this.source.finished = bl2;
        this.sink.finished = bl;
        if (headers != null) {
            this.headersQueue.add(headers);
        }
        if (this.isLocallyInitiated() && headers != null) {
            throw new IllegalStateException("locally-initiated streams shouldn't have headers yet");
        }
        if (!this.isLocallyInitiated() && headers == null) {
            throw new IllegalStateException("remotely-initiated streams should have headers");
        }
    }

    public int getId() {
        return this.id;
    }

    public synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.source.finished && !this.source.closed || !this.sink.finished && !this.sink.closed || !this.hasResponseHeaders;
    }

    public boolean isLocallyInitiated() {
        boolean bl = (this.id & 1) == 1;
        return this.connection.client == bl;
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public synchronized Headers takeHeaders() throws IOException {
        this.readTimeout.enter();
        try {
            while (this.headersQueue.isEmpty() && this.errorCode == null) {
                this.waitForIo();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        if (!this.headersQueue.isEmpty()) {
            return this.headersQueue.removeFirst();
        }
        throw this.errorException != null ? this.errorException : new StreamResetException(this.errorCode);
    }

    public synchronized Headers trailers() throws IOException {
        if (this.errorCode != null) {
            throw this.errorException != null ? this.errorException : new StreamResetException(this.errorCode);
        }
        if (!(this.source.finished && this.source.receiveBuffer.exhausted() && this.source.readBuffer.exhausted())) {
            throw new IllegalStateException("too early; can't read the trailers yet");
        }
        return this.source.trailers != null ? this.source.trailers : Util.EMPTY_HEADERS;
    }

    public synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeaders(List<Header> list, boolean bl, boolean bl2) throws IOException {
        assert (!Thread.holdsLock(this));
        if (list == null) {
            throw new NullPointerException("headers == null");
        }
        Object object = this;
        synchronized (object) {
            this.hasResponseHeaders = true;
            if (bl) {
                this.sink.finished = true;
            }
        }
        if (!bl2) {
            object = this.connection;
            synchronized (object) {
                bl2 = this.connection.bytesLeftInWriteWindow == 0L;
            }
        }
        this.connection.writeHeaders(this.id, bl, list);
        if (bl2) {
            this.connection.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueTrailers(Headers headers) {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.sink.finished) {
                throw new IllegalStateException("already finished");
            }
            if (headers.size() == 0) {
                throw new IllegalArgumentException("trailers.size() == 0");
            }
            this.sink.trailers = headers;
        }
    }

    public Timeout readTimeout() {
        return this.readTimeout;
    }

    public Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public Source getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (!this.hasResponseHeaders && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the sink");
            }
        }
        return this.sink;
    }

    public void close(ErrorCode errorCode, @Nullable IOException iOException) throws IOException {
        if (!this.closeInternal(errorCode, iOException)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode, null)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal(ErrorCode errorCode, @Nullable IOException iOException) {
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.errorCode != null) {
                return false;
            }
            if (this.source.finished && this.sink.finished) {
                return false;
            }
            this.errorCode = errorCode;
            this.errorException = iOException;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    void receiveData(BufferedSource bufferedSource, int n) throws IOException {
        assert (!Thread.holdsLock(this));
        this.source.receive(bufferedSource, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHeaders(Headers headers, boolean bl) {
        boolean bl2;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (!this.hasResponseHeaders || !bl) {
                this.hasResponseHeaders = true;
                this.headersQueue.add(headers);
            } else {
                this.source.trailers = headers;
            }
            if (bl) {
                this.source.finished = true;
            }
            bl2 = this.isOpen();
            this.notifyAll();
        }
        if (!bl2) {
            this.connection.removeStream(this.id);
        }
    }

    synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelStreamIfNecessary() throws IOException {
        boolean bl;
        boolean bl2;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            bl2 = !this.source.finished && this.source.closed && (this.sink.finished || this.sink.closed);
            bl = this.isOpen();
        }
        if (bl2) {
            this.close(ErrorCode.CANCEL, null);
        } else if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    void addBytesToWriteWindow(long l) {
        this.bytesLeftInWriteWindow += l;
        if (l > 0L) {
            this.notifyAll();
        }
    }

    void checkOutNotClosed() throws IOException {
        if (this.sink.closed) {
            throw new IOException("stream closed");
        }
        if (this.sink.finished) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            throw this.errorException != null ? this.errorException : new StreamResetException(this.errorCode);
        }
    }

    void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    class StreamTimeout
    extends AsyncTimeout {
        StreamTimeout() {
        }

        @Override
        protected void timedOut() {
            Http2Stream.this.closeLater(ErrorCode.CANCEL);
            Http2Stream.this.connection.sendDegradedPingLater();
        }

        @Override
        protected IOException newTimeoutException(IOException iOException) {
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
            if (iOException != null) {
                socketTimeoutException.initCause(iOException);
            }
            return socketTimeoutException;
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }
    }

    final class FramingSink
    implements Sink {
        private static final long EMIT_BUFFER_SIZE = 16384L;
        private final Buffer sendBuffer = new Buffer();
        private Headers trailers;
        boolean closed;
        boolean finished;

        FramingSink() {
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            this.sendBuffer.write(buffer, l);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitFrame(boolean bl) throws IOException {
            long l;
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.writeTimeout.enter();
                try {
                    while (Http2Stream.this.bytesLeftInWriteWindow <= 0L && !this.finished && !this.closed && Http2Stream.this.errorCode == null) {
                        Http2Stream.this.waitForIo();
                    }
                }
                finally {
                    Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                }
                Http2Stream.this.checkOutNotClosed();
                l = Math.min(Http2Stream.this.bytesLeftInWriteWindow, this.sendBuffer.size());
                Http2Stream.this.bytesLeftInWriteWindow -= l;
            }
            Http2Stream.this.writeTimeout.enter();
            try {
                boolean bl2 = bl && l == this.sendBuffer.size();
                Http2Stream.this.connection.writeData(Http2Stream.this.id, bl2, this.sendBuffer, l);
            }
            finally {
                Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.checkOutNotClosed();
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                Http2Stream.this.connection.flush();
            }
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.writeTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                if (this.closed) {
                    return;
                }
            }
            if (!Http2Stream.this.sink.finished) {
                boolean bl;
                boolean bl2 = this.sendBuffer.size() > 0L;
                boolean bl3 = bl = this.trailers != null;
                if (bl) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(false);
                    }
                    Http2Stream.this.connection.writeHeaders(Http2Stream.this.id, true, Util.toHeaderBlock(this.trailers));
                } else if (bl2) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else {
                    Http2Stream.this.connection.writeData(Http2Stream.this.id, true, null, 0L);
                }
            }
            Http2Stream http2Stream2 = Http2Stream.this;
            synchronized (http2Stream2) {
                this.closed = true;
            }
            Http2Stream.this.connection.flush();
            Http2Stream.this.cancelStreamIfNecessary();
        }
    }

    private final class FramingSource
    implements Source {
        private final Buffer receiveBuffer = new Buffer();
        private final Buffer readBuffer = new Buffer();
        private final long maxByteCount;
        private Headers trailers;
        boolean closed;
        boolean finished;

        FramingSource(long l) {
            this.maxByteCount = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public long read(Buffer buffer, long l) throws IOException {
            IOException iOException;
            long l2;
            if (l < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l);
            }
            while (true) {
                l2 = -1L;
                iOException = null;
                Http2Stream http2Stream = Http2Stream.this;
                // MONITORENTER : http2Stream
                Http2Stream.this.readTimeout.enter();
                try {
                    if (Http2Stream.this.errorCode != null) {
                        IOException iOException2 = iOException = Http2Stream.this.errorException != null ? Http2Stream.this.errorException : new StreamResetException(Http2Stream.this.errorCode);
                    }
                    if (this.closed) {
                        throw new IOException("stream closed");
                    }
                    if (this.readBuffer.size() > 0L) {
                        l2 = this.readBuffer.read(buffer, Math.min(l, this.readBuffer.size()));
                        Http2Stream.this.unacknowledgedBytesRead += l2;
                        if (iOException != null || Http2Stream.this.unacknowledgedBytesRead < (long)(Http2Stream.this.connection.okHttpSettings.getInitialWindowSize() / 2)) break;
                        Http2Stream.this.connection.writeWindowUpdateLater(Http2Stream.this.id, Http2Stream.this.unacknowledgedBytesRead);
                        Http2Stream.this.unacknowledgedBytesRead = 0L;
                        break;
                    }
                    if (this.finished || iOException != null) break;
                    Http2Stream.this.waitForIo();
                    continue;
                }
                finally {
                    Http2Stream.this.readTimeout.exitAndThrowIfTimedOut();
                    continue;
                }
                break;
            }
            // MONITOREXIT : http2Stream
            if (l2 != -1L) {
                this.updateConnectionFlowControl(l2);
                return l2;
            }
            if (iOException == null) return -1L;
            throw iOException;
        }

        private void updateConnectionFlowControl(long l) {
            assert (!Thread.holdsLock(Http2Stream.this));
            Http2Stream.this.connection.updateConnectionFlowControl(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void receive(BufferedSource bufferedSource, long l) throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            while (l > 0L) {
                boolean bl;
                boolean bl2;
                Http2Stream http2Stream = Http2Stream.this;
                synchronized (http2Stream) {
                    bl2 = this.finished;
                    bl = l + this.readBuffer.size() > this.maxByteCount;
                }
                if (bl) {
                    bufferedSource.skip(l);
                    Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (bl2) {
                    bufferedSource.skip(l);
                    return;
                }
                long l2 = bufferedSource.read(this.receiveBuffer, l);
                if (l2 == -1L) {
                    throw new EOFException();
                }
                l -= l2;
                long l3 = 0L;
                Http2Stream http2Stream2 = Http2Stream.this;
                synchronized (http2Stream2) {
                    if (this.closed) {
                        l3 = this.receiveBuffer.size();
                        this.receiveBuffer.clear();
                    } else {
                        boolean bl3 = this.readBuffer.size() == 0L;
                        this.readBuffer.writeAll(this.receiveBuffer);
                        if (bl3) {
                            Http2Stream.this.notifyAll();
                        }
                    }
                }
                if (l3 <= 0L) continue;
                this.updateConnectionFlowControl(l3);
            }
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.readTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            long l;
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                this.closed = true;
                l = this.readBuffer.size();
                this.readBuffer.clear();
                Http2Stream.this.notifyAll();
            }
            if (l > 0L) {
                this.updateConnectionFlowControl(l);
            }
            Http2Stream.this.cancelStreamIfNecessary();
        }
    }
}

