/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.internal.NamedRunnable;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;

public final class Http2Connection
implements Closeable {
    static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    static final int INTERVAL_PING = 1;
    static final int DEGRADED_PING = 2;
    static final int AWAIT_PING = 3;
    static final long DEGRADED_PONG_TIMEOUT_NS = 1000000000L;
    private static final ExecutorService listenerExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Http2Connection", true));
    final boolean client;
    final Listener listener;
    final Map<Integer, Http2Stream> streams = new LinkedHashMap<Integer, Http2Stream>();
    final String connectionName;
    int lastGoodStreamId;
    int nextStreamId;
    private boolean shutdown;
    private final ScheduledExecutorService writerExecutor;
    private final ExecutorService pushExecutor;
    final PushObserver pushObserver;
    private long intervalPingsSent = 0L;
    private long intervalPongsReceived = 0L;
    private long degradedPingsSent = 0L;
    private long degradedPongsReceived = 0L;
    private long awaitPingsSent = 0L;
    private long awaitPongsReceived = 0L;
    private long degradedPongDeadlineNs = 0L;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings = new Settings();
    final Settings peerSettings = new Settings();
    final Socket socket;
    final Http2Writer writer;
    final ReaderRunnable readerRunnable;
    final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();

    Http2Connection(Builder builder) {
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.listener = builder.listener;
        int n = this.nextStreamId = builder.client ? 1 : 2;
        if (builder.client) {
            this.nextStreamId += 2;
        }
        if (builder.client) {
            this.okHttpSettings.set(7, 0x1000000);
        }
        this.connectionName = builder.connectionName;
        this.writerExecutor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(Util.format("OkHttp %s Writer", this.connectionName), false));
        if (builder.pingIntervalMillis != 0) {
            this.writerExecutor.scheduleAtFixedRate(new IntervalPingRunnable(), builder.pingIntervalMillis, builder.pingIntervalMillis, TimeUnit.MILLISECONDS);
        }
        this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(Util.format("OkHttp %s Push Observer", this.connectionName), true));
        this.peerSettings.set(7, 65535);
        this.peerSettings.set(5, 16384);
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize();
        this.socket = builder.socket;
        this.writer = new Http2Writer(builder.sink, this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.source, this.client));
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    synchronized Http2Stream getStream(int n) {
        return this.streams.get(n);
    }

    synchronized Http2Stream removeStream(int n) {
        Http2Stream http2Stream = this.streams.remove(n);
        this.notifyAll();
        return http2Stream;
    }

    public synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    synchronized void updateConnectionFlowControl(long l) {
        this.unacknowledgedBytesRead += l;
        if (this.unacknowledgedBytesRead >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            this.writeWindowUpdateLater(0, this.unacknowledgedBytesRead);
            this.unacknowledgedBytesRead = 0L;
        }
    }

    public Http2Stream pushStream(int n, List<Header> list, boolean bl) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        return this.newStream(n, list, bl);
    }

    public Http2Stream newStream(List<Header> list, boolean bl) throws IOException {
        return this.newStream(0, list, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2Stream newStream(int n, List<Header> list, boolean bl) throws IOException {
        boolean bl2;
        Http2Stream http2Stream;
        boolean bl3 = !bl;
        boolean bl4 = false;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n2;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                n2 = this.nextStreamId;
                this.nextStreamId += 2;
                http2Stream = new Http2Stream(n2, this, bl3, bl4, null);
                boolean bl5 = bl2 = !bl || this.bytesLeftInWriteWindow == 0L || http2Stream.bytesLeftInWriteWindow == 0L;
                if (http2Stream.isOpen()) {
                    this.streams.put(n2, http2Stream);
                }
            }
            if (n == 0) {
                this.writer.headers(bl3, n2, list);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.writer.pushPromise(n, n2, list);
            }
        }
        if (bl2) {
            this.writer.flush();
        }
        return http2Stream;
    }

    void writeHeaders(int n, boolean bl, List<Header> list) throws IOException {
        this.writer.headers(bl, n, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(int n, boolean bl, Buffer buffer, long l) throws IOException {
        if (l == 0L) {
            this.writer.data(bl, n, buffer, 0);
            return;
        }
        while (l > 0L) {
            int n2;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        if (!this.streams.containsKey(n)) {
                            throw new IOException("stream closed");
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                n2 = (int)Math.min(l, this.bytesLeftInWriteWindow);
                n2 = Math.min(n2, this.writer.maxDataLength());
                this.bytesLeftInWriteWindow -= (long)n2;
            }
            this.writer.data(bl && (l -= (long)n2) == 0L, n, buffer, n2);
        }
    }

    void writeSynResetLater(final int n, final ErrorCode errorCode) {
        try {
            this.writerExecutor.execute(new NamedRunnable("OkHttp %s stream %d", new Object[]{this.connectionName, n}){

                @Override
                public void execute() {
                    try {
                        Http2Connection.this.writeSynReset(n, errorCode);
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection(iOException);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    void writeSynReset(int n, ErrorCode errorCode) throws IOException {
        this.writer.rstStream(n, errorCode);
    }

    void writeWindowUpdateLater(final int n, final long l) {
        try {
            this.writerExecutor.execute(new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.connectionName, n}){

                @Override
                public void execute() {
                    try {
                        Http2Connection.this.writer.windowUpdate(n, l);
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection(iOException);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    void writePing(boolean bl, int n, int n2) {
        try {
            this.writer.ping(bl, n, n2);
        }
        catch (IOException iOException) {
            this.failConnection(iOException);
        }
    }

    void writePingAndAwaitPong() throws InterruptedException {
        this.writePing();
        this.awaitPong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePing() {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            ++this.awaitPingsSent;
        }
        this.writePing(false, 3, 1330343787);
    }

    synchronized void awaitPong() throws InterruptedException {
        while (this.awaitPongsReceived < this.awaitPingsSent) {
            this.wait();
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ErrorCode errorCode) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                n = this.lastGoodStreamId;
            }
            this.writer.goAway(n, errorCode, Util.EMPTY_BYTE_ARRAY);
        }
    }

    @Override
    public void close() {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(ErrorCode errorCode, ErrorCode errorCode2, @Nullable IOException iOException) {
        assert (!Thread.holdsLock(this));
        try {
            this.shutdown(errorCode);
        }
        catch (IOException iOException2) {
            // empty catch block
        }
        Http2Stream[] http2StreamArray = null;
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (!this.streams.isEmpty()) {
                http2StreamArray = this.streams.values().toArray(new Http2Stream[this.streams.size()]);
                this.streams.clear();
            }
        }
        if (http2StreamArray != null) {
            for (Http2Connection http2Connection2 : http2StreamArray) {
                try {
                    ((Http2Stream)((Object)http2Connection2)).close(errorCode2, iOException);
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException4) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException5) {
            // empty catch block
        }
        this.writerExecutor.shutdown();
        this.pushExecutor.shutdown();
    }

    private void failConnection(@Nullable IOException iOException) {
        this.close(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR, iOException);
    }

    public void start() throws IOException {
        this.start(true);
    }

    void start(boolean bl) throws IOException {
        if (bl) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int n = this.okHttpSettings.getInitialWindowSize();
            if (n != 65535) {
                this.writer.windowUpdate(0, n - 65535);
            }
        }
        new Thread(this.readerRunnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(Settings settings) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
            }
            this.writer.settings(settings);
        }
    }

    public synchronized boolean isHealthy(long l) {
        if (this.shutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || l < this.degradedPongDeadlineNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDegradedPingLater() {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            ++this.degradedPingsSent;
            this.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
        }
        try {
            this.writerExecutor.execute(new NamedRunnable("OkHttp %s ping", new Object[]{this.connectionName}){

                @Override
                public void execute() {
                    Http2Connection.this.writePing(false, 2, 0);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    boolean pushedStream(int n) {
        return n != 0 && (n & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushRequestLater(final int n, final List<Header> list) {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.currentPushRequests.contains(n)) {
                this.writeSynResetLater(n, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(n);
        }
        try {
            this.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.connectionName, n}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() {
                    block5: {
                        boolean bl = Http2Connection.this.pushObserver.onRequest(n, list);
                        try {
                            if (!bl) break block5;
                            Http2Connection.this.writer.rstStream(n, ErrorCode.CANCEL);
                            Http2Connection http2Connection = Http2Connection.this;
                            synchronized (http2Connection) {
                                Http2Connection.this.currentPushRequests.remove(n);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    void pushHeadersLater(final int n, final List<Header> list, final boolean bl) {
        try {
            this.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.connectionName, n}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() {
                    block6: {
                        boolean bl2 = Http2Connection.this.pushObserver.onHeaders(n, list, bl);
                        try {
                            if (bl2) {
                                Http2Connection.this.writer.rstStream(n, ErrorCode.CANCEL);
                            }
                            if (!bl2 && !bl) break block6;
                            Http2Connection http2Connection = Http2Connection.this;
                            synchronized (http2Connection) {
                                Http2Connection.this.currentPushRequests.remove(n);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    void pushDataLater(final int n, BufferedSource bufferedSource, final int n2, final boolean bl) throws IOException {
        final Buffer buffer = new Buffer();
        bufferedSource.require(n2);
        bufferedSource.read(buffer, n2);
        if (buffer.size() != (long)n2) {
            throw new IOException(buffer.size() + " != " + n2);
        }
        this.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.connectionName, n}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    try {
                        boolean bl2 = Http2Connection.this.pushObserver.onData(n, buffer, n2, bl);
                        if (bl2) {
                            Http2Connection.this.writer.rstStream(n, ErrorCode.CANCEL);
                        }
                        if (!bl2 && !bl) break block6;
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(n);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void pushResetLater(final int n, final ErrorCode errorCode) {
        this.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.connectionName, n}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                Http2Connection.this.pushObserver.onReset(n, errorCode);
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.currentPushRequests.remove(n);
                }
            }
        });
    }

    private synchronized void pushExecutorExecute(NamedRunnable namedRunnable) {
        if (!this.shutdown) {
            this.pushExecutor.execute(namedRunnable);
        }
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(Http2Stream http2Stream) throws IOException {
                http2Stream.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        public void onSettings(Http2Connection http2Connection) {
        }
    }

    class ReaderRunnable
    extends NamedRunnable
    implements Http2Reader.Handler {
        final Http2Reader reader;

        ReaderRunnable(Http2Reader http2Reader) {
            super("OkHttp %s", Http2Connection.this.connectionName);
            this.reader = http2Reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            ErrorCode errorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode errorCode2 = ErrorCode.INTERNAL_ERROR;
            IOException iOException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                errorCode = ErrorCode.NO_ERROR;
                errorCode2 = ErrorCode.CANCEL;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                errorCode = ErrorCode.PROTOCOL_ERROR;
                errorCode2 = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                Http2Connection.this.close(errorCode, errorCode2, iOException);
                Util.closeQuietly(this.reader);
            }
        }

        @Override
        public void data(boolean bl, int n, BufferedSource bufferedSource, int n2) throws IOException {
            if (Http2Connection.this.pushedStream(n)) {
                Http2Connection.this.pushDataLater(n, bufferedSource, n2, bl);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n);
            if (http2Stream == null) {
                Http2Connection.this.writeSynResetLater(n, ErrorCode.PROTOCOL_ERROR);
                Http2Connection.this.updateConnectionFlowControl(n2);
                bufferedSource.skip(n2);
                return;
            }
            http2Stream.receiveData(bufferedSource, n2);
            if (bl) {
                http2Stream.receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean bl, int n, int n2, List<Header> list) {
            Http2Stream http2Stream;
            if (Http2Connection.this.pushedStream(n)) {
                Http2Connection.this.pushHeadersLater(n, list, bl);
                return;
            }
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                http2Stream = Http2Connection.this.getStream(n);
                if (http2Stream == null) {
                    if (Http2Connection.this.shutdown) {
                        return;
                    }
                    if (n <= Http2Connection.this.lastGoodStreamId) {
                        return;
                    }
                    if (n % 2 == Http2Connection.this.nextStreamId % 2) {
                        return;
                    }
                    Headers headers = Util.toHeaders(list);
                    final Http2Stream http2Stream2 = new Http2Stream(n, Http2Connection.this, false, bl, headers);
                    Http2Connection.this.lastGoodStreamId = n;
                    Http2Connection.this.streams.put(n, http2Stream2);
                    listenerExecutor.execute(new NamedRunnable("OkHttp %s stream %d", new Object[]{Http2Connection.this.connectionName, n}){

                        @Override
                        public void execute() {
                            try {
                                Http2Connection.this.listener.onStream(http2Stream2);
                            }
                            catch (IOException iOException) {
                                Platform.get().log(4, "Http2Connection.Listener failure for " + Http2Connection.this.connectionName, iOException);
                                try {
                                    http2Stream2.close(ErrorCode.PROTOCOL_ERROR, iOException);
                                }
                                catch (IOException iOException2) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    return;
                }
            }
            http2Stream.receiveHeaders(Util.toHeaders(list), bl);
        }

        @Override
        public void rstStream(int n, ErrorCode errorCode) {
            if (Http2Connection.this.pushedStream(n)) {
                Http2Connection.this.pushResetLater(n, errorCode);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.removeStream(n);
            if (http2Stream != null) {
                http2Stream.receiveRstStream(errorCode);
            }
        }

        @Override
        public void settings(final boolean bl, final Settings settings) {
            try {
                Http2Connection.this.writerExecutor.execute(new NamedRunnable("OkHttp %s ACK Settings", new Object[]{Http2Connection.this.connectionName}){

                    @Override
                    public void execute() {
                        ReaderRunnable.this.applyAndAckSettings(bl, settings);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void applyAndAckSettings(boolean bl, Settings settings) {
            int n;
            long l = 0L;
            Http2Stream[] http2StreamArray = null;
            Http2Writer http2Writer = Http2Connection.this.writer;
            synchronized (http2Writer) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    n = Http2Connection.this.peerSettings.getInitialWindowSize();
                    if (bl) {
                        Http2Connection.this.peerSettings.clear();
                    }
                    Http2Connection.this.peerSettings.merge(settings);
                    int n2 = Http2Connection.this.peerSettings.getInitialWindowSize();
                    if (n2 != -1 && n2 != n) {
                        l = n2 - n;
                        http2StreamArray = !Http2Connection.this.streams.isEmpty() ? Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]) : null;
                    }
                }
                try {
                    Http2Connection.this.writer.applyAndAckSettings(Http2Connection.this.peerSettings);
                }
                catch (IOException iOException) {
                    Http2Connection.this.failConnection(iOException);
                }
            }
            if (http2StreamArray != null) {
                http2Writer = http2StreamArray;
                int n3 = ((Http2Writer)http2Writer).length;
                for (n = 0; n < n3; ++n) {
                    Http2Writer http2Writer2;
                    Http2Writer http2Writer3 = http2Writer2 = http2Writer[n];
                    synchronized (http2Writer3) {
                        ((Http2Stream)((Object)http2Writer2)).addBytesToWriteWindow(l);
                        continue;
                    }
                }
            }
            listenerExecutor.execute(new NamedRunnable("OkHttp %s settings", new Object[]{Http2Connection.this.connectionName}){

                @Override
                public void execute() {
                    Http2Connection.this.listener.onSettings(Http2Connection.this);
                }
            });
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping(boolean bl, int n, int n2) {
            if (bl) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    if (n == 1) {
                        Http2Connection.this.intervalPongsReceived++;
                    } else if (n == 2) {
                        Http2Connection.this.degradedPongsReceived++;
                    } else if (n == 3) {
                        Http2Connection.this.awaitPongsReceived++;
                        Http2Connection.this.notifyAll();
                    }
                }
            }
            try {
                Http2Connection.this.writerExecutor.execute(new PingRunnable(true, n, n2));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int n, ErrorCode errorCode, ByteString byteString) {
            if (byteString.size() > 0) {
                // empty if block
            }
            Http2Stream[] http2StreamArray = Http2Connection.this;
            synchronized (Http2Connection.this) {
                Http2Stream[] http2StreamArray2 = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                Http2Connection.this.shutdown = true;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                for (Http2Stream http2Stream : http2StreamArray2) {
                    if (http2Stream.getId() <= n || !http2Stream.isLocallyInitiated()) continue;
                    http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                    Http2Connection.this.removeStream(http2Stream.getId());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int n, long l) {
            if (n == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.bytesLeftInWriteWindow += l;
                    Http2Connection.this.notifyAll();
                }
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n);
            if (http2Stream != null) {
                Http2Stream http2Stream2 = http2Stream;
                synchronized (http2Stream2) {
                    http2Stream.addBytesToWriteWindow(l);
                }
            }
        }

        @Override
        public void priority(int n, int n2, int n3, boolean bl) {
        }

        @Override
        public void pushPromise(int n, int n2, List<Header> list) {
            Http2Connection.this.pushRequestLater(n2, list);
        }

        @Override
        public void alternateService(int n, String string, ByteString byteString, String string2, int n2, long l) {
        }
    }

    public static class Builder {
        Socket socket;
        String connectionName;
        BufferedSource source;
        BufferedSink sink;
        Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        PushObserver pushObserver = PushObserver.CANCEL;
        boolean client;
        int pingIntervalMillis;

        public Builder(boolean bl) {
            this.client = bl;
        }

        public Builder socket(Socket socket) throws IOException {
            SocketAddress socketAddress = socket.getRemoteSocketAddress();
            String string = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostName() : socketAddress.toString();
            return this.socket(socket, string, Okio.buffer(Okio.source(socket)), Okio.buffer(Okio.sink(socket)));
        }

        public Builder socket(Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.socket = socket;
            this.connectionName = string;
            this.source = bufferedSource;
            this.sink = bufferedSink;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public Builder pingIntervalMillis(int n) {
            this.pingIntervalMillis = n;
            return this;
        }

        public Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    final class IntervalPingRunnable
    extends NamedRunnable {
        IntervalPingRunnable() {
            super("OkHttp %s ping", Http2Connection.this.connectionName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            boolean bl;
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                if (Http2Connection.this.intervalPongsReceived < Http2Connection.this.intervalPingsSent) {
                    bl = true;
                } else {
                    Http2Connection.this.intervalPingsSent++;
                    bl = false;
                }
            }
            if (bl) {
                Http2Connection.this.failConnection(null);
            } else {
                Http2Connection.this.writePing(false, 1, 0);
            }
        }
    }

    final class PingRunnable
    extends NamedRunnable {
        final boolean reply;
        final int payload1;
        final int payload2;

        PingRunnable(boolean bl, int n, int n2) {
            super("OkHttp %s ping %08x%08x", Http2Connection.this.connectionName, n, n2);
            this.reply = bl;
            this.payload1 = n;
            this.payload2 = n2;
        }

        @Override
        public void execute() {
            Http2Connection.this.writePing(this.reply, this.payload1, this.payload2);
        }
    }
}

