/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

final class Hpack {
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    static final Header[] STATIC_HEADER_TABLE = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, "GET"), new Header(Header.TARGET_METHOD, "POST"), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, "/index.html"), new Header(Header.TARGET_SCHEME, "http"), new Header(Header.TARGET_SCHEME, "https"), new Header(Header.RESPONSE_STATUS, "200"), new Header(Header.RESPONSE_STATUS, "204"), new Header(Header.RESPONSE_STATUS, "206"), new Header(Header.RESPONSE_STATUS, "304"), new Header(Header.RESPONSE_STATUS, "400"), new Header(Header.RESPONSE_STATUS, "404"), new Header(Header.RESPONSE_STATUS, "500"), new Header("accept-charset", ""), new Header("accept-encoding", "gzip, deflate"), new Header("accept-language", ""), new Header("accept-ranges", ""), new Header("accept", ""), new Header("access-control-allow-origin", ""), new Header("age", ""), new Header("allow", ""), new Header("authorization", ""), new Header("cache-control", ""), new Header("content-disposition", ""), new Header("content-encoding", ""), new Header("content-language", ""), new Header("content-length", ""), new Header("content-location", ""), new Header("content-range", ""), new Header("content-type", ""), new Header("cookie", ""), new Header("date", ""), new Header("etag", ""), new Header("expect", ""), new Header("expires", ""), new Header("from", ""), new Header("host", ""), new Header("if-match", ""), new Header("if-modified-since", ""), new Header("if-none-match", ""), new Header("if-range", ""), new Header("if-unmodified-since", ""), new Header("last-modified", ""), new Header("link", ""), new Header("location", ""), new Header("max-forwards", ""), new Header("proxy-authenticate", ""), new Header("proxy-authorization", ""), new Header("range", ""), new Header("referer", ""), new Header("refresh", ""), new Header("retry-after", ""), new Header("server", ""), new Header("set-cookie", ""), new Header("strict-transport-security", ""), new Header("transfer-encoding", ""), new Header("user-agent", ""), new Header("vary", ""), new Header("via", ""), new Header("www-authenticate", "")};
    static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX = Hpack.nameToFirstIndex();

    private Hpack() {
    }

    private static Map<ByteString, Integer> nameToFirstIndex() {
        LinkedHashMap<ByteString, Integer> linkedHashMap = new LinkedHashMap<ByteString, Integer>(STATIC_HEADER_TABLE.length);
        for (int i = 0; i < STATIC_HEADER_TABLE.length; ++i) {
            if (linkedHashMap.containsKey(Hpack.STATIC_HEADER_TABLE[i].name)) continue;
            linkedHashMap.put(Hpack.STATIC_HEADER_TABLE[i].name, i);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    static ByteString checkLowercase(ByteString byteString) throws IOException {
        int n = byteString.size();
        for (int i = 0; i < n; ++i) {
            byte by = byteString.getByte(i);
            if (by < 65 || by > 90) continue;
            throw new IOException("PROTOCOL_ERROR response malformed: mixed case name: " + byteString.utf8());
        }
        return byteString;
    }

    static final class Writer {
        private static final int SETTINGS_HEADER_TABLE_SIZE = 4096;
        private static final int SETTINGS_HEADER_TABLE_SIZE_LIMIT = 16384;
        private final Buffer out;
        private final boolean useCompression;
        private int smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
        private boolean emitDynamicTableSizeUpdate;
        int headerTableSizeSetting;
        int maxDynamicTableByteCount;
        Header[] dynamicTable = new Header[8];
        int nextHeaderIndex = this.dynamicTable.length - 1;
        int headerCount = 0;
        int dynamicTableByteCount = 0;

        Writer(Buffer buffer) {
            this(4096, true, buffer);
        }

        Writer(int n, boolean bl, Buffer buffer) {
            this.headerTableSizeSetting = n;
            this.maxDynamicTableByteCount = n;
            this.useCompression = bl;
            this.out = buffer;
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n) {
            int n2 = 0;
            if (n > 0) {
                for (int i = this.dynamicTable.length - 1; i >= this.nextHeaderIndex && n > 0; --i) {
                    n -= this.dynamicTable[i].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[i].hpackSize;
                    --this.headerCount;
                    ++n2;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n2, this.headerCount);
                Arrays.fill(this.dynamicTable, this.nextHeaderIndex + 1, this.nextHeaderIndex + 1 + n2, null);
                this.nextHeaderIndex += n2;
            }
            return n2;
        }

        private void insertIntoDynamicTable(Header header) {
            int n = header.hpackSize;
            if (n > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int n2 = this.dynamicTableByteCount + n - this.maxDynamicTableByteCount;
            this.evictToRecoverBytes(n2);
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] headerArray = new Header[this.dynamicTable.length * 2];
                System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray;
            }
            int n3 = this.nextHeaderIndex--;
            this.dynamicTable[n3] = header;
            ++this.headerCount;
            this.dynamicTableByteCount += n;
        }

        void writeHeaders(List<Header> list) throws IOException {
            if (this.emitDynamicTableSizeUpdate) {
                if (this.smallestHeaderTableSizeSetting < this.maxDynamicTableByteCount) {
                    this.writeInt(this.smallestHeaderTableSizeSetting, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
                this.writeInt(this.maxDynamicTableByteCount, 31, 32);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Header header = list.get(i);
                ByteString byteString = header.name.toAsciiLowercase();
                ByteString byteString2 = header.value;
                int n2 = -1;
                int n3 = -1;
                Integer n4 = NAME_TO_FIRST_INDEX.get(byteString);
                if (n4 != null && (n3 = n4 + 1) > 1 && n3 < 8) {
                    if (Objects.equals(Hpack.STATIC_HEADER_TABLE[n3 - 1].value, byteString2)) {
                        n2 = n3;
                    } else if (Objects.equals(Hpack.STATIC_HEADER_TABLE[n3].value, byteString2)) {
                        n2 = n3 + 1;
                    }
                }
                if (n2 == -1) {
                    int n5 = this.dynamicTable.length;
                    for (int j = this.nextHeaderIndex + 1; j < n5; ++j) {
                        if (!Objects.equals(this.dynamicTable[j].name, byteString)) continue;
                        if (Objects.equals(this.dynamicTable[j].value, byteString2)) {
                            n2 = j - this.nextHeaderIndex + STATIC_HEADER_TABLE.length;
                            break;
                        }
                        if (n3 != -1) continue;
                        n3 = j - this.nextHeaderIndex + STATIC_HEADER_TABLE.length;
                    }
                }
                if (n2 != -1) {
                    this.writeInt(n2, 127, 128);
                    continue;
                }
                if (n3 == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(byteString);
                    this.writeByteString(byteString2);
                    this.insertIntoDynamicTable(header);
                    continue;
                }
                if (byteString.startsWith(Header.PSEUDO_PREFIX) && !Header.TARGET_AUTHORITY.equals(byteString)) {
                    this.writeInt(n3, 15, 0);
                    this.writeByteString(byteString2);
                    continue;
                }
                this.writeInt(n3, 63, 64);
                this.writeByteString(byteString2);
                this.insertIntoDynamicTable(header);
            }
        }

        void writeInt(int n, int n2, int n3) {
            if (n < n2) {
                this.out.writeByte(n3 | n);
                return;
            }
            this.out.writeByte(n3 | n2);
            n -= n2;
            while (n >= 128) {
                int n4 = n & 0x7F;
                this.out.writeByte(n4 | 0x80);
                n >>>= 7;
            }
            this.out.writeByte(n);
        }

        void writeByteString(ByteString byteString) throws IOException {
            if (this.useCompression && Huffman.get().encodedLength(byteString) < byteString.size()) {
                Buffer buffer = new Buffer();
                Huffman.get().encode(byteString, buffer);
                ByteString byteString2 = buffer.readByteString();
                this.writeInt(byteString2.size(), 127, 128);
                this.out.write(byteString2);
            } else {
                this.writeInt(byteString.size(), 127, 0);
                this.out.write(byteString);
            }
        }

        void setHeaderTableSizeSetting(int n) {
            this.headerTableSizeSetting = n;
            int n2 = Math.min(n, 16384);
            if (this.maxDynamicTableByteCount == n2) {
                return;
            }
            if (n2 < this.maxDynamicTableByteCount) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n2);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = n2;
            this.adjustDynamicTableByteCount();
        }

        private void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
                }
            }
        }
    }

    static final class Reader {
        private final List<Header> headerList = new ArrayList<Header>();
        private final BufferedSource source;
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        Header[] dynamicTable = new Header[8];
        int nextHeaderIndex = this.dynamicTable.length - 1;
        int headerCount = 0;
        int dynamicTableByteCount = 0;

        Reader(int n, Source source) {
            this(n, n, source);
        }

        Reader(int n, int n2, Source source) {
            this.headerTableSizeSetting = n;
            this.maxDynamicTableByteCount = n2;
            this.source = Okio.buffer(source);
        }

        int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        private void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
                }
            }
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n) {
            int n2 = 0;
            if (n > 0) {
                for (int i = this.dynamicTable.length - 1; i >= this.nextHeaderIndex && n > 0; --i) {
                    n -= this.dynamicTable[i].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[i].hpackSize;
                    --this.headerCount;
                    ++n2;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n2, this.headerCount);
                this.nextHeaderIndex += n2;
            }
            return n2;
        }

        void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int n;
                int n2 = this.source.readByte() & 0xFF;
                if (n2 == 128) {
                    throw new IOException("index == 0");
                }
                if ((n2 & 0x80) == 128) {
                    n = this.readInt(n2, 127);
                    this.readIndexedHeader(n - 1);
                    continue;
                }
                if (n2 == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((n2 & 0x40) == 64) {
                    n = this.readInt(n2, 63);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(n - 1);
                    continue;
                }
                if ((n2 & 0x20) == 32) {
                    this.maxDynamicTableByteCount = this.readInt(n2, 31);
                    if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                        throw new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                    }
                    this.adjustDynamicTableByteCount();
                    continue;
                }
                if (n2 == 16 || n2 == 0) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                n = this.readInt(n2, 15);
                this.readLiteralHeaderWithoutIndexingIndexedName(n - 1);
            }
        }

        public List<Header> getAndResetHeaderList() {
            ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
            this.headerList.clear();
            return arrayList;
        }

        private void readIndexedHeader(int n) throws IOException {
            if (this.isStaticHeader(n)) {
                Header header = STATIC_HEADER_TABLE[n];
                this.headerList.add(header);
            } else {
                int n2 = this.dynamicTableIndex(n - STATIC_HEADER_TABLE.length);
                if (n2 < 0 || n2 >= this.dynamicTable.length) {
                    throw new IOException("Header index too large " + (n + 1));
                }
                this.headerList.add(this.dynamicTable[n2]);
            }
        }

        private int dynamicTableIndex(int n) {
            return this.nextHeaderIndex + 1 + n;
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int n) throws IOException {
            ByteString byteString = this.getName(n);
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n) throws IOException {
            ByteString byteString = this.getName(n);
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private ByteString getName(int n) throws IOException {
            if (this.isStaticHeader(n)) {
                return Hpack.STATIC_HEADER_TABLE[n].name;
            }
            int n2 = this.dynamicTableIndex(n - STATIC_HEADER_TABLE.length);
            if (n2 < 0 || n2 >= this.dynamicTable.length) {
                throw new IOException("Header index too large " + (n + 1));
            }
            return this.dynamicTable[n2].name;
        }

        private boolean isStaticHeader(int n) {
            return n >= 0 && n <= STATIC_HEADER_TABLE.length - 1;
        }

        private void insertIntoDynamicTable(int n, Header header) {
            this.headerList.add(header);
            int n2 = header.hpackSize;
            if (n != -1) {
                n2 -= this.dynamicTable[this.dynamicTableIndex((int)n)].hpackSize;
            }
            if (n2 > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int n3 = this.dynamicTableByteCount + n2 - this.maxDynamicTableByteCount;
            int n4 = this.evictToRecoverBytes(n3);
            if (n == -1) {
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    Header[] headerArray = new Header[this.dynamicTable.length * 2];
                    System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray;
                }
                n = this.nextHeaderIndex--;
                this.dynamicTable[n] = header;
                ++this.headerCount;
            } else {
                n += this.dynamicTableIndex(n) + n4;
                this.dynamicTable[n] = header;
            }
            this.dynamicTableByteCount += n2;
        }

        private int readByte() throws IOException {
            return this.source.readByte() & 0xFF;
        }

        int readInt(int n, int n2) throws IOException {
            int n3;
            int n4 = n & n2;
            if (n4 < n2) {
                return n4;
            }
            int n5 = n2;
            int n6 = 0;
            while (((n3 = this.readByte()) & 0x80) != 0) {
                n5 += (n3 & 0x7F) << n6;
                n6 += 7;
            }
            return n5 += n3 << n6;
        }

        ByteString readByteString() throws IOException {
            int n = this.readByte();
            boolean bl = (n & 0x80) == 128;
            int n2 = this.readInt(n, 127);
            if (bl) {
                return ByteString.of(Huffman.get().decode(this.source.readByteArray(n2)));
            }
            return this.source.readByteString(n2);
        }
    }
}

