/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Http1ExchangeCodec
implements ExchangeCodec {
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;
    private static final int HEADER_LIMIT = 262144;
    private final OkHttpClient client;
    private final RealConnection realConnection;
    private final BufferedSource source;
    private final BufferedSink sink;
    private int state = 0;
    private long headerLimit = 262144L;
    private Headers trailers;

    public Http1ExchangeCodec(OkHttpClient okHttpClient, RealConnection realConnection, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        this.client = okHttpClient;
        this.realConnection = realConnection;
        this.source = bufferedSource;
        this.sink = bufferedSink;
    }

    @Override
    public RealConnection connection() {
        return this.realConnection;
    }

    @Override
    public Sink createRequestBody(Request request, long l) throws IOException {
        if (request.body() != null && request.body().isDuplex()) {
            throw new ProtocolException("Duplex connections are not supported for HTTP/1");
        }
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.newChunkedSink();
        }
        if (l != -1L) {
            return this.newKnownLengthSink();
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public void cancel() {
        if (this.realConnection != null) {
            this.realConnection.cancel();
        }
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        String string = RequestLine.get(request, this.realConnection.route().proxy().type());
        this.writeRequest(request.headers(), string);
    }

    @Override
    public long reportedContentLength(Response response) {
        if (!HttpHeaders.hasBody(response)) {
            return 0L;
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            return -1L;
        }
        return HttpHeaders.contentLength(response);
    }

    @Override
    public Source openResponseBodySource(Response response) {
        if (!HttpHeaders.hasBody(response)) {
            return this.newFixedLengthSource(0L);
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            return this.newChunkedSource(response.request().url());
        }
        long l = HttpHeaders.contentLength(response);
        if (l != -1L) {
            return this.newFixedLengthSource(l);
        }
        return this.newUnknownLengthSource();
    }

    @Override
    public Headers trailers() {
        if (this.state != 6) {
            throw new IllegalStateException("too early; can't read the trailers yet");
        }
        return this.trailers != null ? this.trailers : Util.EMPTY_HEADERS;
    }

    public boolean isClosed() {
        return this.state == 6;
    }

    @Override
    public void flushRequest() throws IOException {
        this.sink.flush();
    }

    @Override
    public void finishRequest() throws IOException {
        this.sink.flush();
    }

    public void writeRequest(Headers headers, String string) throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.sink.writeUtf8(string).writeUtf8("\r\n");
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            this.sink.writeUtf8(headers.name(i)).writeUtf8(": ").writeUtf8(headers.value(i)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    @Override
    public Response.Builder readResponseHeaders(boolean bl) throws IOException {
        if (this.state != 1 && this.state != 3) {
            throw new IllegalStateException("state: " + this.state);
        }
        try {
            StatusLine statusLine = StatusLine.parse(this.readHeaderLine());
            Response.Builder builder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.readHeaders());
            if (bl && statusLine.code == 100) {
                return null;
            }
            if (statusLine.code == 100) {
                this.state = 3;
                return builder;
            }
            this.state = 4;
            return builder;
        }
        catch (EOFException eOFException) {
            String string = "unknown";
            if (this.realConnection != null) {
                string = this.realConnection.route().address().url().redact();
            }
            throw new IOException("unexpected end of stream on " + string, eOFException);
        }
    }

    private String readHeaderLine() throws IOException {
        String string = this.source.readUtf8LineStrict(this.headerLimit);
        this.headerLimit -= (long)string.length();
        return string;
    }

    private Headers readHeaders() throws IOException {
        String string;
        Headers.Builder builder = new Headers.Builder();
        while ((string = this.readHeaderLine()).length() != 0) {
            Internal.instance.addLenient(builder, string);
        }
        return builder.build();
    }

    private Sink newChunkedSink() {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new ChunkedSink();
    }

    private Sink newKnownLengthSink() {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new KnownLengthSink();
    }

    private Source newFixedLengthSource(long l) {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new FixedLengthSource(l);
    }

    private Source newChunkedSource(HttpUrl httpUrl) {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new ChunkedSource(httpUrl);
    }

    private Source newUnknownLengthSource() {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        this.realConnection.noNewExchanges();
        return new UnknownLengthSource();
    }

    private void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout.clearDeadline();
        timeout.clearTimeout();
    }

    public void skipConnectBody(Response response) throws IOException {
        long l = HttpHeaders.contentLength(response);
        if (l == -1L) {
            return;
        }
        Source source = this.newFixedLengthSource(l);
        Util.skipAll(source, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        source.close();
    }

    private class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        private UnknownLengthSource() {
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            if (l < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long l2 = super.read(buffer, l);
            if (l2 == -1L) {
                this.inputExhausted = true;
                this.responseBodyComplete();
                return -1L;
            }
            return l2;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.inputExhausted) {
                this.responseBodyComplete();
            }
            this.closed = true;
        }
    }

    private class ChunkedSource
    extends AbstractSource {
        private static final long NO_CHUNK_YET = -1L;
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;

        ChunkedSource(HttpUrl httpUrl) {
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
            this.url = httpUrl;
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            long l2;
            if (l < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((l2 = super.read(buffer, Math.min(l, this.bytesRemainingInChunk))) == -1L) {
                Http1ExchangeCodec.this.realConnection.noNewExchanges();
                ProtocolException protocolException = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw protocolException;
            }
            this.bytesRemainingInChunk -= l2;
            return l2;
        }

        private void readChunkSize() throws IOException {
            if (this.bytesRemainingInChunk != -1L) {
                Http1ExchangeCodec.this.source.readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = Http1ExchangeCodec.this.source.readHexadecimalUnsignedLong();
                String string = Http1ExchangeCodec.this.source.readUtf8LineStrict().trim();
                if (this.bytesRemainingInChunk < 0L || !string.isEmpty() && !string.startsWith(";")) {
                    throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + string + "\"");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException(numberFormatException.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                Http1ExchangeCodec.this.trailers = Http1ExchangeCodec.this.readHeaders();
                HttpHeaders.receiveHeaders(Http1ExchangeCodec.this.client.cookieJar(), this.url, Http1ExchangeCodec.this.trailers);
                this.responseBodyComplete();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.realConnection.noNewExchanges();
                this.responseBodyComplete();
            }
            this.closed = true;
        }
    }

    private class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        FixedLengthSource(long l) {
            this.bytesRemaining = l;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            if (l < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long l2 = super.read(buffer, Math.min(this.bytesRemaining, l));
            if (l2 == -1L) {
                Http1ExchangeCodec.this.realConnection.noNewExchanges();
                ProtocolException protocolException = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw protocolException;
            }
            this.bytesRemaining -= l2;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
            return l2;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.realConnection.noNewExchanges();
                this.responseBodyComplete();
            }
            this.closed = true;
        }
    }

    private abstract class AbstractSource
    implements Source {
        protected final ForwardingTimeout timeout;
        protected boolean closed;

        private AbstractSource() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.source.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            try {
                return Http1ExchangeCodec.this.source.read(buffer, l);
            }
            catch (IOException iOException) {
                Http1ExchangeCodec.this.realConnection.noNewExchanges();
                this.responseBodyComplete();
                throw iOException;
            }
        }

        final void responseBodyComplete() {
            if (Http1ExchangeCodec.this.state == 6) {
                return;
            }
            if (Http1ExchangeCodec.this.state != 5) {
                throw new IllegalStateException("state: " + Http1ExchangeCodec.this.state);
            }
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 6;
        }
    }

    private final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;

        ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (l == 0L) {
                return;
            }
            Http1ExchangeCodec.this.sink.writeHexadecimalUnsignedLong(l);
            Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
            Http1ExchangeCodec.this.sink.write(buffer, l);
            Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.sink.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.sink.writeUtf8("0\r\n\r\n");
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }

    private final class KnownLengthSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;

        private KnownLengthSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            Util.checkOffsetAndCount(buffer.size(), 0L, l);
            Http1ExchangeCodec.this.sink.write(buffer, l);
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.sink.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }
}

