/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;

public final class RetryAndFollowUpInterceptor
implements Interceptor {
    private static final int MAX_FOLLOW_UPS = 20;
    private final OkHttpClient client;

    public RetryAndFollowUpInterceptor(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RealInterceptorChain realInterceptorChain = (RealInterceptorChain)chain;
        Transmitter transmitter = realInterceptorChain.transmitter();
        int n = 0;
        Response response = null;
        while (true) {
            Exchange exchange;
            Route route;
            Request request2;
            Response response2;
            transmitter.prepareToConnect(request);
            if (transmitter.isCanceled()) {
                throw new IOException("Canceled");
            }
            boolean bl = false;
            try {
                response2 = realInterceptorChain.proceed(request, transmitter, null);
                bl = true;
            }
            catch (RouteException routeException) {
                if (this.recover(routeException.getLastConnectException(), transmitter, false, request)) continue;
                throw routeException.getFirstConnectException();
            }
            catch (IOException iOException) {
                boolean bl2 = !(iOException instanceof ConnectionShutdownException);
                if (this.recover(iOException, transmitter, bl2, request)) continue;
                throw iOException;
            }
            finally {
                if (bl) continue;
                transmitter.exchangeDoneDueToException();
                continue;
            }
            if (response != null) {
                response2 = response2.newBuilder().priorResponse(response.newBuilder().body(null).build()).build();
            }
            if ((request2 = this.followUpRequest(response2, route = (exchange = Internal.instance.exchange(response2)) != null ? exchange.connection().route() : null)) == null) {
                if (exchange != null && exchange.isDuplex()) {
                    transmitter.timeoutEarlyExit();
                }
                return response2;
            }
            RequestBody requestBody = request2.body();
            if (requestBody != null && requestBody.isOneShot()) {
                return response2;
            }
            Util.closeQuietly(response2.body());
            if (transmitter.hasExchange()) {
                exchange.detachWithViolence();
            }
            if (++n > 20) {
                throw new ProtocolException("Too many follow-up requests: " + n);
            }
            request = request2;
            response = response2;
        }
    }

    private boolean recover(IOException iOException, Transmitter transmitter, boolean bl, Request request) {
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (bl && this.requestIsOneShot(iOException, request)) {
            return false;
        }
        if (!this.isRecoverable(iOException, bl)) {
            return false;
        }
        return transmitter.canRetry();
    }

    private boolean requestIsOneShot(IOException iOException, Request request) {
        RequestBody requestBody = request.body();
        return requestBody != null && requestBody.isOneShot() || iOException instanceof FileNotFoundException;
    }

    private boolean isRecoverable(IOException iOException, boolean bl) {
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return iOException instanceof SocketTimeoutException && !bl;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }

    private Request followUpRequest(Response response, @Nullable Route route) throws IOException {
        if (response == null) {
            throw new IllegalStateException();
        }
        int n = response.code();
        String string = response.request().method();
        switch (n) {
            case 407: {
                Proxy proxy;
                Proxy proxy2 = proxy = route != null ? route.proxy() : this.client.proxy();
                if (proxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate(route, response);
            }
            case 401: {
                return this.client.authenticator().authenticate(route, response);
            }
            case 307: 
            case 308: {
                if (!string.equals("GET") && !string.equals("HEAD")) {
                    return null;
                }
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                if (!this.client.followRedirects()) {
                    return null;
                }
                String string2 = response.header("Location");
                if (string2 == null) {
                    return null;
                }
                HttpUrl httpUrl = response.request().url().resolve(string2);
                if (httpUrl == null) {
                    return null;
                }
                boolean bl = httpUrl.scheme().equals(response.request().url().scheme());
                if (!bl && !this.client.followSslRedirects()) {
                    return null;
                }
                Request.Builder builder = response.request().newBuilder();
                if (HttpMethod.permitsRequestBody(string)) {
                    boolean bl2 = HttpMethod.redirectsWithBody(string);
                    if (HttpMethod.redirectsToGet(string)) {
                        builder.method("GET", null);
                    } else {
                        RequestBody requestBody = bl2 ? response.request().body() : null;
                        builder.method(string, requestBody);
                    }
                    if (!bl2) {
                        builder.removeHeader("Transfer-Encoding");
                        builder.removeHeader("Content-Length");
                        builder.removeHeader("Content-Type");
                    }
                }
                if (!Util.sameConnection(response.request().url(), httpUrl)) {
                    builder.removeHeader("Authorization");
                }
                return builder.url(httpUrl).build();
            }
            case 408: {
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                RequestBody requestBody = response.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                if (response.priorResponse() != null && response.priorResponse().code() == 408) {
                    return null;
                }
                if (this.retryAfter(response, 0) > 0) {
                    return null;
                }
                return response.request();
            }
            case 503: {
                if (response.priorResponse() != null && response.priorResponse().code() == 503) {
                    return null;
                }
                if (this.retryAfter(response, Integer.MAX_VALUE) == 0) {
                    return response.request();
                }
                return null;
            }
        }
        return null;
    }

    private int retryAfter(Response response, int n) {
        String string = response.header("Retry-After");
        if (string == null) {
            return n;
        }
        if (string.matches("\\d+")) {
            return Integer.valueOf(string);
        }
        return Integer.MAX_VALUE;
    }
}

