/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import okhttp3.Challenge;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.ByteString;

public final class HttpHeaders {
    private static final ByteString QUOTED_STRING_DELIMITERS = ByteString.encodeUtf8("\"\\");
    private static final ByteString TOKEN_DELIMITERS = ByteString.encodeUtf8("\t ,=");

    private HttpHeaders() {
    }

    public static long contentLength(Response response) {
        return HttpHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return HttpHeaders.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String string) {
        if (string == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response response, Headers headers, Request request) {
        for (String string : HttpHeaders.varyFields(response)) {
            if (Objects.equals(headers.values(string), request.headers(string))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return HttpHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers headers) {
        return HttpHeaders.varyFields(headers).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return HttpHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers headers) {
        Set<String> set = Collections.emptySet();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            if (!"Vary".equalsIgnoreCase(headers.name(i))) continue;
            String string = headers.value(i);
            if (set.isEmpty()) {
                set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String string2 : string.split(",")) {
                set.add(string2.trim());
            }
        }
        return set;
    }

    public static Headers varyHeaders(Response response) {
        Headers headers = response.networkResponse().request().headers();
        Headers headers2 = response.headers();
        return HttpHeaders.varyHeaders(headers, headers2);
    }

    public static Headers varyHeaders(Headers headers, Headers headers2) {
        Set<String> set = HttpHeaders.varyFields(headers2);
        if (set.isEmpty()) {
            return Util.EMPTY_HEADERS;
        }
        Headers.Builder builder = new Headers.Builder();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            String string = headers.name(i);
            if (!set.contains(string)) continue;
            builder.add(string, headers.value(i));
        }
        return builder.build();
    }

    public static List<Challenge> parseChallenges(Headers headers, String string) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        for (int i = 0; i < headers.size(); ++i) {
            if (!string.equalsIgnoreCase(headers.name(i))) continue;
            Buffer buffer = new Buffer().writeUtf8(headers.value(i));
            HttpHeaders.parseChallengeHeader(arrayList, buffer);
        }
        return arrayList;
    }

    private static void parseChallengeHeader(List<Challenge> list, Buffer buffer) {
        String string = null;
        while (true) {
            LinkedHashMap<String, String> linkedHashMap;
            String string2;
            block11: {
                if (string == null) {
                    HttpHeaders.skipWhitespaceAndCommas(buffer);
                    string = HttpHeaders.readToken(buffer);
                    if (string == null) {
                        return;
                    }
                }
                string2 = string;
                boolean bl = HttpHeaders.skipWhitespaceAndCommas(buffer);
                string = HttpHeaders.readToken(buffer);
                if (string == null) {
                    if (!buffer.exhausted()) {
                        return;
                    }
                    list.add(new Challenge(string2, Collections.emptyMap()));
                    return;
                }
                int n = HttpHeaders.skipAll(buffer, (byte)61);
                boolean bl2 = HttpHeaders.skipWhitespaceAndCommas(buffer);
                if (!bl && (bl2 || buffer.exhausted())) {
                    list.add(new Challenge(string2, Collections.singletonMap(null, string + HttpHeaders.repeat('=', n))));
                    string = null;
                    continue;
                }
                linkedHashMap = new LinkedHashMap<String, String>();
                n += HttpHeaders.skipAll(buffer, (byte)61);
                do {
                    String string3;
                    if (string == null) {
                        string = HttpHeaders.readToken(buffer);
                        if (HttpHeaders.skipWhitespaceAndCommas(buffer)) break block11;
                        n = HttpHeaders.skipAll(buffer, (byte)61);
                    }
                    if (n == 0) break block11;
                    if (n > 1) {
                        return;
                    }
                    if (HttpHeaders.skipWhitespaceAndCommas(buffer)) {
                        return;
                    }
                    String string4 = string3 = !buffer.exhausted() && buffer.getByte(0L) == 34 ? HttpHeaders.readQuotedString(buffer) : HttpHeaders.readToken(buffer);
                    if (string3 == null) {
                        return;
                    }
                    String string5 = linkedHashMap.put(string, string3);
                    string = null;
                    if (string5 == null) continue;
                    return;
                } while (HttpHeaders.skipWhitespaceAndCommas(buffer) || buffer.exhausted());
                return;
            }
            list.add(new Challenge(string2, linkedHashMap));
        }
    }

    private static boolean skipWhitespaceAndCommas(Buffer buffer) {
        boolean bl = false;
        while (!buffer.exhausted()) {
            byte by = buffer.getByte(0L);
            if (by == 44) {
                buffer.readByte();
                bl = true;
                continue;
            }
            if (by != 32 && by != 9) break;
            buffer.readByte();
        }
        return bl;
    }

    private static int skipAll(Buffer buffer, byte by) {
        int n = 0;
        while (!buffer.exhausted() && buffer.getByte(0L) == by) {
            ++n;
            buffer.readByte();
        }
        return n;
    }

    private static String readQuotedString(Buffer buffer) {
        if (buffer.readByte() != 34) {
            throw new IllegalArgumentException();
        }
        Buffer buffer2 = new Buffer();
        long l;
        while ((l = buffer.indexOfElement(QUOTED_STRING_DELIMITERS)) != -1L) {
            if (buffer.getByte(l) == 34) {
                buffer2.write(buffer, l);
                buffer.readByte();
                return buffer2.readUtf8();
            }
            if (buffer.size() == l + 1L) {
                return null;
            }
            buffer2.write(buffer, l);
            buffer.readByte();
            buffer2.write(buffer, 1L);
        }
        return null;
    }

    private static String readToken(Buffer buffer) {
        try {
            long l = buffer.indexOfElement(TOKEN_DELIMITERS);
            if (l == -1L) {
                l = buffer.size();
            }
            return l != 0L ? buffer.readUtf8(l) : null;
        }
        catch (EOFException eOFException) {
            throw new AssertionError();
        }
    }

    private static String repeat(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static void receiveHeaders(CookieJar cookieJar, HttpUrl httpUrl, Headers headers) {
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        List<Cookie> list = Cookie.parseAll(httpUrl, headers);
        if (list.isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(httpUrl, list);
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int n = response.code();
        if ((n < 100 || n >= 200) && n != 204 && n != 304) {
            return true;
        }
        return HttpHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    public static int skipUntil(String string, int n, String string2) {
        while (n < string.length() && string2.indexOf(string.charAt(n)) == -1) {
            ++n;
        }
        return n;
    }

    public static int skipWhitespace(String string, int n) {
        char c;
        while (n < string.length() && ((c = string.charAt(n)) == ' ' || c == '\t')) {
            ++n;
        }
        return n;
    }

    public static int parseSeconds(String string, int n) {
        try {
            long l = Long.parseLong(string);
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (l < 0L) {
                return 0;
            }
            return (int)l;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }
}

