/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okio.BufferedSink;
import okio.Okio;

public final class CallServerInterceptor
implements Interceptor {
    private final boolean forWebSocket;

    public CallServerInterceptor(boolean bl) {
        this.forWebSocket = bl;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        int n;
        Closeable closeable;
        RealInterceptorChain realInterceptorChain = (RealInterceptorChain)chain;
        Exchange exchange = realInterceptorChain.exchange();
        Request request = realInterceptorChain.request();
        long l = System.currentTimeMillis();
        exchange.writeRequestHeaders(request);
        boolean bl = false;
        Response.Builder builder = null;
        if (HttpMethod.permitsRequestBody(request.method()) && request.body() != null) {
            if ("100-continue".equalsIgnoreCase(request.header("Expect"))) {
                exchange.flushRequest();
                bl = true;
                exchange.responseHeadersStart();
                builder = exchange.readResponseHeaders(true);
            }
            if (builder == null) {
                if (request.body().isDuplex()) {
                    exchange.flushRequest();
                    closeable = Okio.buffer(exchange.createRequestBody(request, true));
                    request.body().writeTo((BufferedSink)closeable);
                } else {
                    closeable = Okio.buffer(exchange.createRequestBody(request, false));
                    request.body().writeTo((BufferedSink)closeable);
                    closeable.close();
                }
            } else {
                exchange.noRequestBody();
                if (!exchange.connection().isMultiplexed()) {
                    exchange.noNewExchangesOnConnection();
                }
            }
        } else {
            exchange.noRequestBody();
        }
        if (request.body() == null || !request.body().isDuplex()) {
            exchange.finishRequest();
        }
        if (!bl) {
            exchange.responseHeadersStart();
        }
        if (builder == null) {
            builder = exchange.readResponseHeaders(false);
        }
        if ((n = ((Response)(closeable = builder.request(request).handshake(exchange.connection().handshake()).sentRequestAtMillis(l).receivedResponseAtMillis(System.currentTimeMillis()).build())).code()) == 100) {
            closeable = exchange.readResponseHeaders(false).request(request).handshake(exchange.connection().handshake()).sentRequestAtMillis(l).receivedResponseAtMillis(System.currentTimeMillis()).build();
            n = ((Response)closeable).code();
        }
        exchange.responseHeadersEnd((Response)closeable);
        closeable = this.forWebSocket && n == 101 ? ((Response)closeable).newBuilder().body(Util.EMPTY_RESPONSE).build() : ((Response)closeable).newBuilder().body(exchange.openResponseBody((Response)closeable)).build();
        if ("close".equalsIgnoreCase(((Response)closeable).request().header("Connection")) || "close".equalsIgnoreCase(((Response)closeable).header("Connection"))) {
            exchange.noNewExchangesOnConnection();
        }
        if ((n == 204 || n == 205) && ((Response)closeable).body().contentLength() > 0L) {
            throw new ProtocolException("HTTP " + n + " had non-zero Content-Length: " + ((Response)closeable).body().contentLength());
        }
        return closeable;
    }
}

