/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;
import okio.Timeout;

public final class Transmitter {
    private final OkHttpClient client;
    private final RealConnectionPool connectionPool;
    private final Call call;
    private final EventListener eventListener;
    private final AsyncTimeout timeout = new AsyncTimeout(){

        @Override
        protected void timedOut() {
            Transmitter.this.cancel();
        }
    };
    @Nullable
    private Object callStackTrace;
    private Request request;
    private ExchangeFinder exchangeFinder;
    public RealConnection connection;
    @Nullable
    private Exchange exchange;
    private boolean exchangeRequestDone;
    private boolean exchangeResponseDone;
    private boolean canceled;
    private boolean timeoutEarlyExit;
    private boolean noMoreExchanges;

    public Transmitter(OkHttpClient okHttpClient, Call call) {
        this.client = okHttpClient;
        this.connectionPool = Internal.instance.realConnectionPool(okHttpClient.connectionPool());
        this.call = call;
        this.eventListener = okHttpClient.eventListenerFactory().create(call);
        this.timeout.timeout(okHttpClient.callTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public void timeoutEnter() {
        this.timeout.enter();
    }

    public void timeoutEarlyExit() {
        if (this.timeoutEarlyExit) {
            throw new IllegalStateException();
        }
        this.timeoutEarlyExit = true;
        this.timeout.exit();
    }

    @Nullable
    private IOException timeoutExit(@Nullable IOException iOException) {
        if (this.timeoutEarlyExit) {
            return iOException;
        }
        if (!this.timeout.exit()) {
            return iOException;
        }
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        if (iOException != null) {
            interruptedIOException.initCause(iOException);
        }
        return interruptedIOException;
    }

    public void callStart() {
        this.callStackTrace = Platform.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this.call);
    }

    public void prepareToConnect(Request request) {
        if (this.request != null) {
            if (Util.sameConnection(this.request.url(), request.url()) && this.exchangeFinder.hasRouteToTry()) {
                return;
            }
            if (this.exchange != null) {
                throw new IllegalStateException();
            }
            if (this.exchangeFinder != null) {
                this.maybeReleaseConnection(null, true);
                this.exchangeFinder = null;
            }
        }
        this.request = request;
        this.exchangeFinder = new ExchangeFinder(this, this.connectionPool, this.createAddress(request.url()), this.call, this.eventListener);
    }

    private Address createAddress(HttpUrl httpUrl) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (httpUrl.isHttps()) {
            sSLSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(httpUrl.host(), httpUrl.port(), this.client.dns(), this.client.socketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Exchange newExchange(Interceptor.Chain chain, boolean bl) {
        Object object = this.connectionPool;
        synchronized (object) {
            if (this.noMoreExchanges) {
                throw new IllegalStateException("released");
            }
            if (this.exchange != null) {
                throw new IllegalStateException("cannot make a new request because the previous response is still open: please call response.close()");
            }
        }
        object = this.exchangeFinder.find(this.client, chain, bl);
        Exchange exchange = new Exchange(this, this.call, this.eventListener, this.exchangeFinder, (ExchangeCodec)object);
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.exchange = exchange;
            this.exchangeRequestDone = false;
            this.exchangeResponseDone = false;
            return exchange;
        }
    }

    void acquireConnectionNoEvents(RealConnection realConnection) {
        assert (Thread.holdsLock(this.connectionPool));
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        this.connection = realConnection;
        realConnection.transmitters.add(new TransmitterReference(this, this.callStackTrace));
    }

    @Nullable
    Socket releaseConnectionNoEvents() {
        assert (Thread.holdsLock(this.connectionPool));
        int n = -1;
        int n2 = this.connection.transmitters.size();
        for (int i = 0; i < n2; ++i) {
            Reference<Transmitter> reference = this.connection.transmitters.get(i);
            if (reference.get() != this) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalStateException();
        }
        RealConnection realConnection = this.connection;
        realConnection.transmitters.remove(n);
        this.connection = null;
        if (realConnection.transmitters.isEmpty()) {
            realConnection.idleAtNanos = System.nanoTime();
            if (this.connectionPool.connectionBecameIdle(realConnection)) {
                return realConnection.socket();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeDoneDueToException() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            if (this.noMoreExchanges) {
                throw new IllegalStateException();
            }
            this.exchange = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IOException exchangeMessageDone(Exchange exchange, boolean bl, boolean bl2, @Nullable IOException iOException) {
        boolean bl3 = false;
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            if (exchange != this.exchange) {
                return iOException;
            }
            boolean bl4 = false;
            if (bl) {
                if (!this.exchangeRequestDone) {
                    bl4 = true;
                }
                this.exchangeRequestDone = true;
            }
            if (bl2) {
                if (!this.exchangeResponseDone) {
                    bl4 = true;
                }
                this.exchangeResponseDone = true;
            }
            if (this.exchangeRequestDone && this.exchangeResponseDone && bl4) {
                bl3 = true;
                ++this.exchange.connection().successCount;
                this.exchange = null;
            }
        }
        if (bl3) {
            iOException = this.maybeReleaseConnection(iOException, false);
        }
        return iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IOException noMoreExchanges(@Nullable IOException iOException) {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.noMoreExchanges = true;
        }
        return this.maybeReleaseConnection(iOException, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IOException maybeReleaseConnection(@Nullable IOException iOException, boolean bl) {
        boolean bl2;
        Socket socket;
        RealConnection realConnection;
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            if (bl && this.exchange != null) {
                throw new IllegalStateException("cannot release connection while it is in use");
            }
            realConnection = this.connection;
            Socket socket2 = socket = this.connection != null && this.exchange == null && (bl || this.noMoreExchanges) ? this.releaseConnectionNoEvents() : null;
            if (this.connection != null) {
                realConnection = null;
            }
            bl2 = this.noMoreExchanges && this.exchange == null;
        }
        Util.closeQuietly(socket);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
        if (bl2) {
            boolean bl3 = iOException != null;
            iOException = this.timeoutExit(iOException);
            if (bl3) {
                this.eventListener.callFailed(this.call, iOException);
            } else {
                this.eventListener.callEnd(this.call);
            }
        }
        return iOException;
    }

    public boolean canRetry() {
        return this.exchangeFinder.hasStreamFailure() && this.exchangeFinder.hasRouteToTry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExchange() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            return this.exchange != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RealConnection realConnection;
        Exchange exchange;
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.canceled = true;
            exchange = this.exchange;
            realConnection = this.exchangeFinder != null && this.exchangeFinder.connectingConnection() != null ? this.exchangeFinder.connectingConnection() : this.connection;
        }
        if (exchange != null) {
            exchange.cancel();
        } else if (realConnection != null) {
            realConnection.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            return this.canceled;
        }
    }

    static final class TransmitterReference
    extends WeakReference<Transmitter> {
        final Object callStackTrace;

        TransmitterReference(Transmitter transmitter, Object object) {
            super(transmitter);
            this.callStackTrace = object;
        }
    }
}

