/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.ExchangeCodec;

final class ExchangeFinder {
    private final Transmitter transmitter;
    private final Address address;
    private final RealConnectionPool connectionPool;
    private final Call call;
    private final EventListener eventListener;
    private RouteSelector.Selection routeSelection;
    private final RouteSelector routeSelector;
    private RealConnection connectingConnection;
    private boolean hasStreamFailure;
    private Route nextRouteToTry;

    ExchangeFinder(Transmitter transmitter, RealConnectionPool realConnectionPool, Address address, Call call, EventListener eventListener) {
        this.transmitter = transmitter;
        this.connectionPool = realConnectionPool;
        this.address = address;
        this.call = call;
        this.eventListener = eventListener;
        this.routeSelector = new RouteSelector(address, realConnectionPool.routeDatabase, call, eventListener);
    }

    public ExchangeCodec find(OkHttpClient okHttpClient, Interceptor.Chain chain, boolean bl) {
        int n = chain.connectTimeoutMillis();
        int n2 = chain.readTimeoutMillis();
        int n3 = chain.writeTimeoutMillis();
        int n4 = okHttpClient.pingIntervalMillis();
        boolean bl2 = okHttpClient.retryOnConnectionFailure();
        try {
            RealConnection realConnection = this.findHealthyConnection(n, n2, n3, n4, bl2, bl);
            return realConnection.newCodec(okHttpClient, chain);
        }
        catch (RouteException routeException) {
            this.trackFailure();
            throw routeException;
        }
        catch (IOException iOException) {
            this.trackFailure();
            throw new RouteException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findHealthyConnection(int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws IOException {
        RealConnection realConnection;
        while (true) {
            realConnection = this.findConnection(n, n2, n3, n4, bl);
            RealConnectionPool realConnectionPool = this.connectionPool;
            synchronized (realConnectionPool) {
                if (realConnection.successCount == 0 && !realConnection.isMultiplexed()) {
                    return realConnection;
                }
            }
            if (realConnection.isHealthy(bl2)) break;
            realConnection.noNewExchanges();
        }
        return realConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findConnection(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        Socket socket;
        RealConnection realConnection;
        boolean bl2 = false;
        RealConnection realConnection2 = null;
        Route route = null;
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            if (this.transmitter.isCanceled()) {
                throw new IOException("Canceled");
            }
            this.hasStreamFailure = false;
            realConnection = this.transmitter.connection;
            Socket socket2 = socket = this.transmitter.connection != null && this.transmitter.connection.noNewExchanges ? this.transmitter.releaseConnectionNoEvents() : null;
            if (this.transmitter.connection != null) {
                realConnection2 = this.transmitter.connection;
                realConnection = null;
            }
            if (realConnection2 == null) {
                if (this.connectionPool.transmitterAcquirePooledConnection(this.address, this.transmitter, null, false)) {
                    bl2 = true;
                    realConnection2 = this.transmitter.connection;
                } else if (this.nextRouteToTry != null) {
                    route = this.nextRouteToTry;
                    this.nextRouteToTry = null;
                } else if (this.retryCurrentRoute()) {
                    route = this.transmitter.connection.route();
                }
            }
        }
        Util.closeQuietly(socket);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
        if (bl2) {
            this.eventListener.connectionAcquired(this.call, realConnection2);
        }
        if (realConnection2 != null) {
            return realConnection2;
        }
        boolean bl3 = false;
        if (!(route != null || this.routeSelection != null && this.routeSelection.hasNext())) {
            bl3 = true;
            this.routeSelection = this.routeSelector.next();
        }
        List<Route> list = null;
        Object object = this.connectionPool;
        synchronized (object) {
            if (this.transmitter.isCanceled()) {
                throw new IOException("Canceled");
            }
            if (bl3 && this.connectionPool.transmitterAcquirePooledConnection(this.address, this.transmitter, list = this.routeSelection.getAll(), false)) {
                bl2 = true;
                realConnection2 = this.transmitter.connection;
            }
            if (!bl2) {
                if (route == null) {
                    route = this.routeSelection.next();
                }
                this.connectingConnection = realConnection2 = new RealConnection(this.connectionPool, route);
            }
        }
        if (bl2) {
            this.eventListener.connectionAcquired(this.call, realConnection2);
            return realConnection2;
        }
        realConnection2.connect(n, n2, n3, n4, bl, this.call, this.eventListener);
        this.connectionPool.routeDatabase.connected(realConnection2.route());
        object = null;
        RealConnectionPool realConnectionPool2 = this.connectionPool;
        synchronized (realConnectionPool2) {
            this.connectingConnection = null;
            if (this.connectionPool.transmitterAcquirePooledConnection(this.address, this.transmitter, list, true)) {
                realConnection2.noNewExchanges = true;
                object = realConnection2.socket();
                realConnection2 = this.transmitter.connection;
                this.nextRouteToTry = route;
            } else {
                this.connectionPool.put(realConnection2);
                this.transmitter.acquireConnectionNoEvents(realConnection2);
            }
        }
        Util.closeQuietly((Socket)object);
        this.eventListener.connectionAcquired(this.call, realConnection2);
        return realConnection2;
    }

    RealConnection connectingConnection() {
        assert (Thread.holdsLock(this.connectionPool));
        return this.connectingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackFailure() {
        assert (!Thread.holdsLock(this.connectionPool));
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.hasStreamFailure = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasStreamFailure() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            return this.hasStreamFailure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRouteToTry() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            if (this.nextRouteToTry != null) {
                return true;
            }
            if (this.retryCurrentRoute()) {
                this.nextRouteToTry = this.transmitter.connection.route();
                return true;
            }
            return this.routeSelection != null && this.routeSelection.hasNext() || this.routeSelector.hasNext();
        }
    }

    private boolean retryCurrentRoute() {
        return this.transmitter.connection != null && this.transmitter.connection.routeFailureCount == 0 && Util.sameConnection(this.transmitter.connection.route().address().url(), this.address.url());
    }
}

