/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealResponseBody;
import okhttp3.internal.ws.RealWebSocket;
import okio.Buffer;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Exchange {
    final Transmitter transmitter;
    final Call call;
    final EventListener eventListener;
    final ExchangeFinder finder;
    final ExchangeCodec codec;
    private boolean duplex;

    public Exchange(Transmitter transmitter, Call call, EventListener eventListener, ExchangeFinder exchangeFinder, ExchangeCodec exchangeCodec) {
        this.transmitter = transmitter;
        this.call = call;
        this.eventListener = eventListener;
        this.finder = exchangeFinder;
        this.codec = exchangeCodec;
    }

    public RealConnection connection() {
        return this.codec.connection();
    }

    public boolean isDuplex() {
        return this.duplex;
    }

    public void writeRequestHeaders(Request request) throws IOException {
        try {
            this.eventListener.requestHeadersStart(this.call);
            this.codec.writeRequestHeaders(request);
            this.eventListener.requestHeadersEnd(this.call, request);
        }
        catch (IOException iOException) {
            this.eventListener.requestFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public Sink createRequestBody(Request request, boolean bl) throws IOException {
        this.duplex = bl;
        long l = request.body().contentLength();
        this.eventListener.requestBodyStart(this.call);
        Sink sink = this.codec.createRequestBody(request, l);
        return new RequestBodySink(sink, l);
    }

    public void flushRequest() throws IOException {
        try {
            this.codec.flushRequest();
        }
        catch (IOException iOException) {
            this.eventListener.requestFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public void finishRequest() throws IOException {
        try {
            this.codec.finishRequest();
        }
        catch (IOException iOException) {
            this.eventListener.requestFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public void responseHeadersStart() {
        this.eventListener.responseHeadersStart(this.call);
    }

    @Nullable
    public Response.Builder readResponseHeaders(boolean bl) throws IOException {
        try {
            Response.Builder builder = this.codec.readResponseHeaders(bl);
            if (builder != null) {
                Internal.instance.initExchange(builder, this);
            }
            return builder;
        }
        catch (IOException iOException) {
            this.eventListener.responseFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public void responseHeadersEnd(Response response) {
        this.eventListener.responseHeadersEnd(this.call, response);
    }

    public ResponseBody openResponseBody(Response response) throws IOException {
        try {
            this.eventListener.responseBodyStart(this.call);
            String string = response.header("Content-Type");
            long l = this.codec.reportedContentLength(response);
            Source source = this.codec.openResponseBodySource(response);
            ResponseBodySource responseBodySource = new ResponseBodySource(source, l);
            return new RealResponseBody(string, l, Okio.buffer(responseBodySource));
        }
        catch (IOException iOException) {
            this.eventListener.responseFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public Headers trailers() throws IOException {
        return this.codec.trailers();
    }

    public void timeoutEarlyExit() {
        this.transmitter.timeoutEarlyExit();
    }

    public RealWebSocket.Streams newWebSocketStreams() throws SocketException {
        this.transmitter.timeoutEarlyExit();
        return this.codec.connection().newWebSocketStreams(this);
    }

    public void webSocketUpgradeFailed() {
        this.bodyComplete(-1L, true, true, null);
    }

    public void noNewExchangesOnConnection() {
        this.codec.connection().noNewExchanges();
    }

    public void cancel() {
        this.codec.cancel();
    }

    public void detachWithViolence() {
        this.codec.cancel();
        this.transmitter.exchangeMessageDone(this, true, true, null);
    }

    void trackFailure(IOException iOException) {
        this.finder.trackFailure();
        this.codec.connection().trackFailure(iOException);
    }

    @Nullable
    IOException bodyComplete(long l, boolean bl, boolean bl2, @Nullable IOException iOException) {
        if (iOException != null) {
            this.trackFailure(iOException);
        }
        if (bl2) {
            if (iOException != null) {
                this.eventListener.requestFailed(this.call, iOException);
            } else {
                this.eventListener.requestBodyEnd(this.call, l);
            }
        }
        if (bl) {
            if (iOException != null) {
                this.eventListener.responseFailed(this.call, iOException);
            } else {
                this.eventListener.responseBodyEnd(this.call, l);
            }
        }
        return this.transmitter.exchangeMessageDone(this, bl2, bl, iOException);
    }

    public void noRequestBody() {
        this.transmitter.exchangeMessageDone(this, true, false, null);
    }

    final class ResponseBodySource
    extends ForwardingSource {
        private final long contentLength;
        private long bytesReceived;
        private boolean completed;
        private boolean closed;

        ResponseBodySource(Source source, long l) {
            super(source);
            this.contentLength = l;
            if (l == 0L) {
                this.complete(null);
            }
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            try {
                long l2 = this.delegate().read(buffer, l);
                if (l2 == -1L) {
                    this.complete(null);
                    return -1L;
                }
                long l3 = this.bytesReceived + l2;
                if (this.contentLength != -1L && l3 > this.contentLength) {
                    throw new ProtocolException("expected " + this.contentLength + " bytes but received " + l3);
                }
                this.bytesReceived = l3;
                if (l3 == this.contentLength) {
                    this.complete(null);
                }
                return l2;
            }
            catch (IOException iOException) {
                throw this.complete(iOException);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
                this.complete(null);
            }
            catch (IOException iOException) {
                throw this.complete(iOException);
            }
        }

        @Nullable
        IOException complete(@Nullable IOException iOException) {
            if (this.completed) {
                return iOException;
            }
            this.completed = true;
            return Exchange.this.bodyComplete(this.bytesReceived, true, false, iOException);
        }
    }

    private final class RequestBodySink
    extends ForwardingSink {
        private boolean completed;
        private long contentLength;
        private long bytesReceived;
        private boolean closed;

        RequestBodySink(Sink sink, long l) {
            super(sink);
            this.contentLength = l;
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.contentLength != -1L && this.bytesReceived + l > this.contentLength) {
                throw new ProtocolException("expected " + this.contentLength + " bytes but received " + (this.bytesReceived + l));
            }
            try {
                super.write(buffer, l);
                this.bytesReceived += l;
            }
            catch (IOException iOException) {
                throw this.complete(iOException);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                super.flush();
            }
            catch (IOException iOException) {
                throw this.complete(iOException);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.contentLength != -1L && this.bytesReceived != this.contentLength) {
                throw new ProtocolException("unexpected end of stream");
            }
            try {
                super.close();
                this.complete(null);
            }
            catch (IOException iOException) {
                throw this.complete(iOException);
            }
        }

        @Nullable
        private IOException complete(@Nullable IOException iOException) {
            if (this.completed) {
                return iOException;
            }
            this.completed = true;
            return Exchange.this.bodyComplete(this.bytesReceived, false, true, iOException);
        }
    }
}

