/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import okhttp3.internal.Util;
import okhttp3.internal.cache2.FileOperator;
import okio.Buffer;
import okio.ByteString;
import okio.Source;
import okio.Timeout;

final class Relay {
    private static final int SOURCE_UPSTREAM = 1;
    private static final int SOURCE_FILE = 2;
    static final ByteString PREFIX_CLEAN = ByteString.encodeUtf8("OkHttp cache v1\n");
    static final ByteString PREFIX_DIRTY = ByteString.encodeUtf8("OkHttp DIRTY :(\n");
    private static final long FILE_HEADER_SIZE = 32L;
    RandomAccessFile file;
    Thread upstreamReader;
    Source upstream;
    final Buffer upstreamBuffer = new Buffer();
    long upstreamPos;
    boolean complete;
    private final ByteString metadata;
    final Buffer buffer = new Buffer();
    final long bufferMaxSize;
    int sourceCount;

    private Relay(RandomAccessFile randomAccessFile, Source source, long l, ByteString byteString, long l2) {
        this.file = randomAccessFile;
        this.upstream = source;
        this.complete = source == null;
        this.upstreamPos = l;
        this.metadata = byteString;
        this.bufferMaxSize = l2;
    }

    public static Relay edit(File file, Source source, ByteString byteString, long l) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        Relay relay = new Relay(randomAccessFile, source, 0L, byteString, l);
        randomAccessFile.setLength(0L);
        relay.writeHeader(PREFIX_DIRTY, -1L, -1L);
        return relay;
    }

    public static Relay read(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        FileOperator fileOperator = new FileOperator(randomAccessFile.getChannel());
        Buffer buffer = new Buffer();
        fileOperator.read(0L, buffer, 32L);
        ByteString byteString = buffer.readByteString(PREFIX_CLEAN.size());
        if (!byteString.equals(PREFIX_CLEAN)) {
            throw new IOException("unreadable cache file");
        }
        long l = buffer.readLong();
        long l2 = buffer.readLong();
        Buffer buffer2 = new Buffer();
        fileOperator.read(32L + l, buffer2, l2);
        ByteString byteString2 = buffer2.readByteString();
        return new Relay(randomAccessFile, null, l, byteString2, 0L);
    }

    private void writeHeader(ByteString byteString, long l, long l2) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write(byteString);
        buffer.writeLong(l);
        buffer.writeLong(l2);
        if (buffer.size() != 32L) {
            throw new IllegalArgumentException();
        }
        FileOperator fileOperator = new FileOperator(this.file.getChannel());
        fileOperator.write(0L, buffer, 32L);
    }

    private void writeMetadata(long l) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write(this.metadata);
        FileOperator fileOperator = new FileOperator(this.file.getChannel());
        fileOperator.write(32L + l, buffer, this.metadata.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(long l) throws IOException {
        this.writeMetadata(l);
        this.file.getChannel().force(false);
        this.writeHeader(PREFIX_CLEAN, l, this.metadata.size());
        this.file.getChannel().force(false);
        Relay relay = this;
        synchronized (relay) {
            this.complete = true;
        }
        Util.closeQuietly(this.upstream);
        this.upstream = null;
    }

    boolean isClosed() {
        return this.file == null;
    }

    public ByteString metadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source newSource() {
        Relay relay = this;
        synchronized (relay) {
            if (this.file == null) {
                return null;
            }
            ++this.sourceCount;
        }
        return new RelaySource();
    }

    class RelaySource
    implements Source {
        private final Timeout timeout = new Timeout();
        private FileOperator fileOperator;
        private long sourcePos;

        RelaySource() {
            this.fileOperator = new FileOperator(Relay.this.file.getChannel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(Buffer buffer, long l) throws IOException {
            int n;
            long l2;
            block27: {
                if (this.fileOperator == null) {
                    throw new IllegalStateException("closed");
                }
                Relay relay = Relay.this;
                synchronized (relay) {
                    while (this.sourcePos == (l2 = Relay.this.upstreamPos)) {
                        if (Relay.this.complete) {
                            return -1L;
                        }
                        if (Relay.this.upstreamReader != null) {
                            this.timeout.waitUntilNotified(Relay.this);
                            continue;
                        }
                        Relay.this.upstreamReader = Thread.currentThread();
                        n = 1;
                        break block27;
                    }
                    long l3 = l2 - Relay.this.buffer.size();
                    if (this.sourcePos < l3) {
                        n = 2;
                        break block27;
                    }
                    long l4 = Math.min(l, l2 - this.sourcePos);
                    Relay.this.buffer.copyTo(buffer, this.sourcePos - l3, l4);
                    this.sourcePos += l4;
                    return l4;
                }
            }
            if (n == 2) {
                long l5 = Math.min(l, l2 - this.sourcePos);
                this.fileOperator.read(32L + this.sourcePos, buffer, l5);
                this.sourcePos += l5;
                return l5;
            }
            try {
                long l6 = Relay.this.upstream.read(Relay.this.upstreamBuffer, Relay.this.bufferMaxSize);
                if (l6 == -1L) {
                    Relay.this.commit(l2);
                    long l7 = -1L;
                    return l7;
                }
                long l8 = Math.min(l6, l);
                Relay.this.upstreamBuffer.copyTo(buffer, 0L, l8);
                this.sourcePos += l8;
                this.fileOperator.write(32L + l2, Relay.this.upstreamBuffer.clone(), l6);
                Relay relay = Relay.this;
                synchronized (relay) {
                    Relay.this.buffer.write(Relay.this.upstreamBuffer, l6);
                    if (Relay.this.buffer.size() > Relay.this.bufferMaxSize) {
                        Relay.this.buffer.skip(Relay.this.buffer.size() - Relay.this.bufferMaxSize);
                    }
                    Relay.this.upstreamPos += l6;
                }
                long l9 = l8;
                return l9;
            }
            finally {
                Relay relay = Relay.this;
                synchronized (relay) {
                    Relay.this.upstreamReader = null;
                    Relay.this.notifyAll();
                }
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.fileOperator == null) {
                return;
            }
            this.fileOperator = null;
            RandomAccessFile randomAccessFile = null;
            Relay relay = Relay.this;
            synchronized (relay) {
                --Relay.this.sourceCount;
                if (Relay.this.sourceCount == 0) {
                    randomAccessFile = Relay.this.file;
                    Relay.this.file = null;
                }
            }
            if (randomAccessFile != null) {
                Util.closeQuietly(randomAccessFile);
            }
        }
    }
}

