/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.cache.InternalCache;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class CacheInterceptor
implements Interceptor {
    @Nullable
    final InternalCache cache;

    public CacheInterceptor(@Nullable InternalCache internalCache) {
        this.cache = internalCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = this.cache != null ? this.cache.get(chain.request()) : null;
        long l = System.currentTimeMillis();
        CacheStrategy cacheStrategy = new CacheStrategy.Factory(l, chain.request(), response).get();
        Request request = cacheStrategy.networkRequest;
        Response response2 = cacheStrategy.cacheResponse;
        if (this.cache != null) {
            this.cache.trackResponse(cacheStrategy);
        }
        if (response != null && response2 == null) {
            Util.closeQuietly(response.body());
        }
        if (request == null && response2 == null) {
            return new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
        }
        if (request == null) {
            return response2.newBuilder().cacheResponse(CacheInterceptor.stripBody(response2)).build();
        }
        Response response3 = null;
        try {
            response3 = chain.proceed(request);
        }
        finally {
            if (response3 == null && response != null) {
                Util.closeQuietly(response.body());
            }
        }
        if (response2 != null) {
            if (response3.code() == 304) {
                Response response4 = response2.newBuilder().headers(CacheInterceptor.combine(response2.headers(), response3.headers())).sentRequestAtMillis(response3.sentRequestAtMillis()).receivedResponseAtMillis(response3.receivedResponseAtMillis()).cacheResponse(CacheInterceptor.stripBody(response2)).networkResponse(CacheInterceptor.stripBody(response3)).build();
                response3.body().close();
                this.cache.trackConditionalCacheHit();
                this.cache.update(response2, response4);
                return response4;
            }
            Util.closeQuietly(response2.body());
        }
        Response response5 = response3.newBuilder().cacheResponse(CacheInterceptor.stripBody(response2)).networkResponse(CacheInterceptor.stripBody(response3)).build();
        if (this.cache != null) {
            if (HttpHeaders.hasBody(response5) && CacheStrategy.isCacheable(response5, request)) {
                CacheRequest cacheRequest = this.cache.put(response5);
                return this.cacheWritingResponse(cacheRequest, response5);
            }
            if (HttpMethod.invalidatesCache(request.method())) {
                try {
                    this.cache.remove(request);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return response5;
    }

    private static Response stripBody(Response response) {
        return response != null && response.body() != null ? response.newBuilder().body(null).build() : response;
    }

    private Response cacheWritingResponse(final CacheRequest cacheRequest, Response response) throws IOException {
        if (cacheRequest == null) {
            return response;
        }
        Sink sink = cacheRequest.body();
        if (sink == null) {
            return response;
        }
        final BufferedSource bufferedSource = response.body().source();
        final BufferedSink bufferedSink = Okio.buffer(sink);
        Source source = new Source(){
            boolean cacheRequestClosed;

            @Override
            public long read(Buffer buffer, long l) throws IOException {
                long l2;
                try {
                    l2 = bufferedSource.read(buffer, l);
                }
                catch (IOException iOException) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        cacheRequest.abort();
                    }
                    throw iOException;
                }
                if (l2 == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        bufferedSink.close();
                    }
                    return -1L;
                }
                buffer.copyTo(bufferedSink.buffer(), buffer.size() - l2, l2);
                bufferedSink.emitCompleteSegments();
                return l2;
            }

            @Override
            public Timeout timeout() {
                return bufferedSource.timeout();
            }

            @Override
            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    cacheRequest.abort();
                }
                bufferedSource.close();
            }
        };
        String string = response.header("Content-Type");
        long l = response.body().contentLength();
        return response.newBuilder().body(new RealResponseBody(string, l, Okio.buffer(source))).build();
    }

    private static Headers combine(Headers headers, Headers headers2) {
        String string;
        int n;
        Headers.Builder builder = new Headers.Builder();
        int n2 = headers.size();
        for (n = 0; n < n2; ++n) {
            string = headers.name(n);
            String string2 = headers.value(n);
            if ("Warning".equalsIgnoreCase(string) && string2.startsWith("1") || !CacheInterceptor.isContentSpecificHeader(string) && CacheInterceptor.isEndToEnd(string) && headers2.get(string) != null) continue;
            Internal.instance.addLenient(builder, string, string2);
        }
        n2 = headers2.size();
        for (n = 0; n < n2; ++n) {
            string = headers2.name(n);
            if (CacheInterceptor.isContentSpecificHeader(string) || !CacheInterceptor.isEndToEnd(string)) continue;
            Internal.instance.addLenient(builder, string, headers2.value(n));
        }
        return builder.build();
    }

    static boolean isEndToEnd(String string) {
        return !"Connection".equalsIgnoreCase(string) && !"Keep-Alive".equalsIgnoreCase(string) && !"Proxy-Authenticate".equalsIgnoreCase(string) && !"Proxy-Authorization".equalsIgnoreCase(string) && !"TE".equalsIgnoreCase(string) && !"Trailers".equalsIgnoreCase(string) && !"Transfer-Encoding".equalsIgnoreCase(string) && !"Upgrade".equalsIgnoreCase(string);
    }

    static boolean isContentSpecificHeader(String string) {
        return "Content-Length".equalsIgnoreCase(string) || "Content-Encoding".equalsIgnoreCase(string) || "Content-Type".equalsIgnoreCase(string);
    }
}

