/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.http2.Header;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Source;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final Headers EMPTY_HEADERS;
    public static final ResponseBody EMPTY_RESPONSE;
    public static final RequestBody EMPTY_REQUEST;
    private static final Options UNICODE_BOMS;
    private static final Charset UTF_32BE;
    private static final Charset UTF_32LE;
    public static final TimeZone UTC;
    public static final Comparator<String> NATURAL_ORDER;
    private static final Method addSuppressedExceptionMethod;
    private static final Pattern VERIFY_AS_IP_ADDRESS;

    public static void addSuppressedIfPossible(Throwable throwable, Throwable throwable2) {
        if (addSuppressedExceptionMethod != null) {
            try {
                addSuppressedExceptionMethod.invoke((Object)throwable, throwable2);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private Util() {
    }

    public static void checkOffsetAndCount(long l, long l2, long l3) {
        if ((l2 | l3) < 0L || l2 > l || l - l2 < l3) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (AssertionError assertionError) {
                if (!Util.isAndroidGetsocknameError(assertionError)) {
                    throw assertionError;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean discard(Source source, int n, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source, n, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean skipAll(Source source, int n, TimeUnit timeUnit) throws IOException {
        long l = System.nanoTime();
        long l2 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(l + Math.min(l2, timeUnit.toNanos(n)));
        try {
            Buffer buffer = new Buffer();
            while (source.read(buffer, 8192L) != -1L) {
                buffer.clear();
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedIOException interruptedIOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (l2 == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(l + l2);
            }
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    @SafeVarargs
    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static ThreadFactory threadFactory(String string, boolean bl) {
        return runnable -> {
            Thread thread = new Thread(runnable, string);
            thread.setDaemon(bl);
            return thread;
        };
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string : stringArray) {
            for (String string2 : stringArray2) {
                if (comparator.compare(string, string2) != 0) continue;
                arrayList.add(string);
                continue block0;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length == 0 || stringArray2.length == 0) {
            return false;
        }
        for (String string : stringArray) {
            for (String string2 : stringArray2) {
                if (comparator.compare(string, string2) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String hostHeader(HttpUrl httpUrl, boolean bl) {
        String string = httpUrl.host().contains(":") ? "[" + httpUrl.host() + "]" : httpUrl.host();
        return bl || httpUrl.port() != HttpUrl.defaultPort(httpUrl.scheme()) ? string + ":" + httpUrl.port() : string;
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }

    public static int indexOf(Comparator<String> comparator, String[] stringArray, String string) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (comparator.compare(stringArray[i], string) != 0) continue;
            return i;
        }
        return -1;
    }

    public static String[] concat(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public static int skipLeadingAsciiWhitespace(String string, int n, int n2) {
        block3: for (int i = n; i < n2; ++i) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return n2;
    }

    public static int skipTrailingAsciiWhitespace(String string, int n, int n2) {
        block3: for (int i = n2 - 1; i >= n; --i) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i + 1;
                }
            }
        }
        return n;
    }

    public static String trimSubstring(String string, int n, int n2) {
        int n3 = Util.skipLeadingAsciiWhitespace(string, n, n2);
        int n4 = Util.skipTrailingAsciiWhitespace(string, n3, n2);
        return string.substring(n3, n4);
    }

    public static int delimiterOffset(String string, int n, int n2, String string2) {
        for (int i = n; i < n2; ++i) {
            if (string2.indexOf(string.charAt(i)) == -1) continue;
            return i;
        }
        return n2;
    }

    public static int delimiterOffset(String string, int n, int n2, char c) {
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            return i;
        }
        return n2;
    }

    public static String canonicalizeHost(String string) {
        if (string.contains(":")) {
            InetAddress inetAddress;
            InetAddress inetAddress2 = inetAddress = string.startsWith("[") && string.endsWith("]") ? Util.decodeIpv6(string, 1, string.length() - 1) : Util.decodeIpv6(string, 0, string.length());
            if (inetAddress == null) {
                return null;
            }
            byte[] byArray = inetAddress.getAddress();
            if (byArray.length == 16) {
                return Util.inet6AddressToAscii(byArray);
            }
            if (byArray.length == 4) {
                return inetAddress.getHostAddress();
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + string + "'"));
        }
        try {
            String string2 = IDN.toASCII(string).toLowerCase(Locale.US);
            if (string2.isEmpty()) {
                return null;
            }
            if (Util.containsInvalidHostnameAsciiCodes(string2)) {
                return null;
            }
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static boolean containsInvalidHostnameAsciiCodes(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u001f' || c >= '\u007f') {
                return true;
            }
            if (" #%/:?@[\\]".indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    public static int indexOfControlOrNonAscii(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u001f' && c < '\u007f') continue;
            return i;
        }
        return -1;
    }

    public static boolean verifyAsIpAddress(String string) {
        return VERIFY_AS_IP_ADDRESS.matcher(string).matches();
    }

    public static String format(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public static Charset bomAwareCharset(BufferedSource bufferedSource, Charset charset) throws IOException {
        switch (bufferedSource.select(UNICODE_BOMS)) {
            case 0: {
                return StandardCharsets.UTF_8;
            }
            case 1: {
                return StandardCharsets.UTF_16BE;
            }
            case 2: {
                return StandardCharsets.UTF_16LE;
            }
            case 3: {
                return UTF_32BE;
            }
            case 4: {
                return UTF_32LE;
            }
            case -1: {
                return charset;
            }
        }
        throw new AssertionError();
    }

    public static int checkDuration(String string, long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException(string + " < 0");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit == null");
        }
        long l2 = timeUnit.toMillis(l);
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(string + " too large.");
        }
        if (l2 == 0L && l > 0L) {
            throw new IllegalArgumentException(string + " too small.");
        }
        return (int)l2;
    }

    public static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    @Nullable
    private static InetAddress decodeIpv6(String string, int n, int n2) {
        byte[] byArray = new byte[16];
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = n;
        while (n6 < n2) {
            char c;
            int n7;
            if (n3 == byArray.length) {
                return null;
            }
            if (n6 + 2 <= n2 && string.regionMatches(n6, "::", 0, 2)) {
                if (n4 != -1) {
                    return null;
                }
                n4 = n3 += 2;
                if ((n6 += 2) == n2) {
                    break;
                }
            } else if (n3 != 0 && !string.regionMatches(n6, ":", 0, 1)) {
                if (string.regionMatches(n6, ".", 0, 1)) {
                    if (!Util.decodeIpv4Suffix(string, n5, n2, byArray, n3 - 2)) {
                        return null;
                    }
                    n3 += 2;
                    break;
                }
                return null;
            }
            int n8 = 0;
            n5 = ++n6;
            while (n6 < n2 && (n7 = Util.decodeHexDigit(c = string.charAt(n6))) != -1) {
                n8 = (n8 << 4) + n7;
                ++n6;
            }
            c = n6 - n5;
            if (c == '\u0000' || c > '\u0004') {
                return null;
            }
            byArray[n3++] = (byte)(n8 >>> 8 & 0xFF);
            byArray[n3++] = (byte)(n8 & 0xFF);
        }
        if (n3 != byArray.length) {
            if (n4 == -1) {
                return null;
            }
            System.arraycopy(byArray, n4, byArray, byArray.length - (n3 - n4), n3 - n4);
            Arrays.fill(byArray, n4, n4 + (byArray.length - n3), (byte)0);
        }
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError();
        }
    }

    private static boolean decodeIpv4Suffix(String string, int n, int n2, byte[] byArray, int n3) {
        int n4 = n3;
        int n5 = n;
        while (n5 < n2) {
            int n6;
            if (n4 == byArray.length) {
                return false;
            }
            if (n4 != n3 && string.charAt(n5) != '.') {
                return false;
            }
            int n7 = 0;
            int n8 = ++n5;
            while (n5 < n2 && (n6 = string.charAt(n5)) >= 48 && n6 <= 57) {
                if (n7 == 0 && n8 != n5) {
                    return false;
                }
                if ((n7 = n7 * 10 + n6 - 48) > 255) {
                    return false;
                }
                ++n5;
            }
            n6 = n5 - n8;
            if (n6 == 0) {
                return false;
            }
            byArray[n4++] = (byte)n7;
        }
        return n4 == n3 + 4;
    }

    private static String inet6AddressToAscii(byte[] byArray) {
        int n;
        int n2;
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < byArray.length; i += 2) {
            n2 = i;
            while (i < 16 && byArray[i] == 0 && byArray[i + 1] == 0) {
                i += 2;
            }
            n = i - n2;
            if (n <= n4 || n < 4) continue;
            n3 = n2;
            n4 = n;
        }
        Buffer buffer = new Buffer();
        n2 = 0;
        while (n2 < byArray.length) {
            if (n2 == n3) {
                buffer.writeByte(58);
                if ((n2 += n4) != 16) continue;
                buffer.writeByte(58);
                continue;
            }
            if (n2 > 0) {
                buffer.writeByte(58);
            }
            n = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
            buffer.writeHexadecimalUnsignedLong(n);
            n2 += 2;
        }
        return buffer.readUtf8();
    }

    public static X509TrustManager platformTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] objectArray = trustManagerFactory.getTrustManagers();
            if (objectArray.length != 1 || !(objectArray[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
            }
            return (X509TrustManager)objectArray[0];
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError("No System TLS", generalSecurityException);
        }
    }

    public static Headers toHeaders(List<Header> list) {
        Headers.Builder builder = new Headers.Builder();
        for (Header header : list) {
            Internal.instance.addLenient(builder, header.name.utf8(), header.value.utf8());
        }
        return builder.build();
    }

    public static List<Header> toHeaderBlock(Headers headers) {
        ArrayList<Header> arrayList = new ArrayList<Header>();
        for (int i = 0; i < headers.size(); ++i) {
            arrayList.add(new Header(headers.name(i), headers.value(i)));
        }
        return arrayList;
    }

    public static String getSystemProperty(String string, @Nullable String string2) {
        String string3;
        try {
            string3 = System.getProperty(string);
        }
        catch (AccessControlException accessControlException) {
            return string2;
        }
        return string3 != null ? string3 : string2;
    }

    public static boolean sameConnection(HttpUrl httpUrl, HttpUrl httpUrl2) {
        return httpUrl.host().equals(httpUrl2.host()) && httpUrl.port() == httpUrl2.port() && httpUrl.scheme().equals(httpUrl2.scheme());
    }

    static {
        Method method;
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_HEADERS = Headers.of(new String[0]);
        EMPTY_RESPONSE = ResponseBody.create(null, EMPTY_BYTE_ARRAY);
        EMPTY_REQUEST = RequestBody.create(null, EMPTY_BYTE_ARRAY);
        UNICODE_BOMS = Options.of(ByteString.decodeHex("efbbbf"), ByteString.decodeHex("feff"), ByteString.decodeHex("fffe"), ByteString.decodeHex("0000ffff"), ByteString.decodeHex("ffff0000"));
        UTF_32BE = Charset.forName("UTF-32BE");
        UTF_32LE = Charset.forName("UTF-32LE");
        UTC = TimeZone.getTimeZone("GMT");
        NATURAL_ORDER = String::compareTo;
        try {
            method = Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class);
        }
        catch (Exception exception) {
            method = null;
        }
        addSuppressedExceptionMethod = method;
        VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
    }
}

