/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.annotation.Nullable;
import okhttp3.Address;

public final class Route {
    final Address address;
    final Proxy proxy;
    final InetSocketAddress inetSocketAddress;

    public Route(Address address, Proxy proxy, InetSocketAddress inetSocketAddress) {
        if (address == null) {
            throw new NullPointerException("address == null");
        }
        if (proxy == null) {
            throw new NullPointerException("proxy == null");
        }
        if (inetSocketAddress == null) {
            throw new NullPointerException("inetSocketAddress == null");
        }
        this.address = address;
        this.proxy = proxy;
        this.inetSocketAddress = inetSocketAddress;
    }

    public Address address() {
        return this.address;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public InetSocketAddress socketAddress() {
        return this.inetSocketAddress;
    }

    public boolean requiresTunnel() {
        return this.address.sslSocketFactory != null && this.proxy.type() == Proxy.Type.HTTP;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof Route && ((Route)object).address.equals(this.address) && ((Route)object).proxy.equals(this.proxy) && ((Route)object).inetSocketAddress.equals(this.inetSocketAddress);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.address.hashCode();
        n = 31 * n + this.proxy.hashCode();
        n = 31 * n + this.inetSocketAddress.hashCode();
        return n;
    }

    public String toString() {
        return "Route{" + this.inetSocketAddress + "}";
    }
}

