/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

public abstract class ResponseBody
implements Closeable {
    @Nullable
    private Reader reader;

    @Nullable
    public abstract MediaType contentType();

    public abstract long contentLength();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferedSource source();

    public final byte[] bytes() throws IOException {
        byte[] byArray;
        long l = this.contentLength();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + l);
        }
        try (BufferedSource bufferedSource = this.source();){
            byArray = bufferedSource.readByteArray();
        }
        if (l != -1L && l != (long)byArray.length) {
            throw new IOException("Content-Length (" + l + ") and stream length (" + byArray.length + ") disagree");
        }
        return byArray;
    }

    public final Reader charStream() {
        Reader reader = this.reader;
        return reader != null ? reader : (this.reader = new BomAwareReader(this.source(), this.charset()));
    }

    public final String string() throws IOException {
        try (BufferedSource bufferedSource = this.source();){
            Charset charset = Util.bomAwareCharset(bufferedSource, this.charset());
            String string = bufferedSource.readString(charset);
            return string;
        }
    }

    private Charset charset() {
        MediaType mediaType = this.contentType();
        return mediaType != null ? mediaType.charset(StandardCharsets.UTF_8) : StandardCharsets.UTF_8;
    }

    @Override
    public void close() {
        Util.closeQuietly(this.source());
    }

    public static ResponseBody create(@Nullable MediaType mediaType, String string) {
        Charset charset = StandardCharsets.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = StandardCharsets.UTF_8;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        Buffer buffer = new Buffer().writeString(string, charset);
        return ResponseBody.create(mediaType, buffer.size(), buffer);
    }

    public static ResponseBody create(@Nullable MediaType mediaType, byte[] byArray) {
        Buffer buffer = new Buffer().write(byArray);
        return ResponseBody.create(mediaType, byArray.length, buffer);
    }

    public static ResponseBody create(@Nullable MediaType mediaType, ByteString byteString) {
        Buffer buffer = new Buffer().write(byteString);
        return ResponseBody.create(mediaType, byteString.size(), buffer);
    }

    public static ResponseBody create(final @Nullable MediaType mediaType, final long l, final BufferedSource bufferedSource) {
        if (bufferedSource == null) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody(){

            @Override
            @Nullable
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public long contentLength() {
                return l;
            }

            @Override
            public BufferedSource source() {
                return bufferedSource;
            }
        };
    }

    static final class BomAwareReader
    extends Reader {
        private final BufferedSource source;
        private final Charset charset;
        private boolean closed;
        @Nullable
        private Reader delegate;

        BomAwareReader(BufferedSource bufferedSource, Charset charset) {
            this.source = bufferedSource;
            this.charset = charset;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            Reader reader = this.delegate;
            if (reader == null) {
                Charset charset = Util.bomAwareCharset(this.source, this.charset);
                reader = this.delegate = new InputStreamReader(this.source.inputStream(), charset);
            }
            return reader.read(cArray, n, n2);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.delegate != null) {
                this.delegate.close();
            } else {
                this.source.close();
            }
        }
    }
}

