/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.NamedRunnable;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.Timeout;

final class RealCall
implements Call {
    final OkHttpClient client;
    private Transmitter transmitter;
    final Request originalRequest;
    final boolean forWebSocket;
    private boolean executed;

    private RealCall(OkHttpClient okHttpClient, Request request, boolean bl) {
        this.client = okHttpClient;
        this.originalRequest = request;
        this.forWebSocket = bl;
    }

    static RealCall newRealCall(OkHttpClient okHttpClient, Request request, boolean bl) {
        RealCall realCall = new RealCall(okHttpClient, request, bl);
        realCall.transmitter = new Transmitter(okHttpClient, realCall);
        return realCall;
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.transmitter.timeoutEnter();
        this.transmitter.callStart();
        try {
            this.client.dispatcher().executed(this);
            object = this.getResponseWithInterceptorChain();
            return object;
        }
        finally {
            this.client.dispatcher().finished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Callback callback) {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.transmitter.callStart();
        this.client.dispatcher().enqueue(new AsyncCall(callback));
    }

    @Override
    public void cancel() {
        this.transmitter.cancel();
    }

    @Override
    public Timeout timeout() {
        return this.transmitter.timeout();
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isCanceled() {
        return this.transmitter.isCanceled();
    }

    @Override
    public RealCall clone() {
        return RealCall.newRealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl();
    }

    String redactedUrl() {
        return this.originalRequest.url().redact();
    }

    Response getResponseWithInterceptorChain() throws IOException {
        ArrayList<Interceptor> arrayList = new ArrayList<Interceptor>();
        arrayList.addAll(this.client.interceptors());
        arrayList.add(new RetryAndFollowUpInterceptor(this.client));
        arrayList.add(new BridgeInterceptor(this.client.cookieJar()));
        arrayList.add(new CacheInterceptor(this.client.internalCache()));
        arrayList.add(new ConnectInterceptor(this.client));
        if (!this.forWebSocket) {
            arrayList.addAll(this.client.networkInterceptors());
        }
        arrayList.add(new CallServerInterceptor(this.forWebSocket));
        RealInterceptorChain realInterceptorChain = new RealInterceptorChain(arrayList, this.transmitter, null, 0, this.originalRequest, this, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean bl = false;
        try {
            Response response = realInterceptorChain.proceed(this.originalRequest);
            if (this.transmitter.isCanceled()) {
                Util.closeQuietly(response);
                throw new IOException("Canceled");
            }
            Response response2 = response;
            return response2;
        }
        catch (IOException iOException) {
            bl = true;
            throw this.transmitter.noMoreExchanges(iOException);
        }
        finally {
            if (!bl) {
                this.transmitter.noMoreExchanges(null);
            }
        }
    }

    final class AsyncCall
    extends NamedRunnable {
        private final Callback responseCallback;
        private volatile AtomicInteger callsPerHost;

        AsyncCall(Callback callback) {
            super("OkHttp %s", RealCall.this.redactedUrl());
            this.callsPerHost = new AtomicInteger(0);
            this.responseCallback = callback;
        }

        AtomicInteger callsPerHost() {
            return this.callsPerHost;
        }

        void reuseCallsPerHostFrom(AsyncCall asyncCall) {
            this.callsPerHost = asyncCall.callsPerHost;
        }

        String host() {
            return RealCall.this.originalRequest.url().host();
        }

        Request request() {
            return RealCall.this.originalRequest;
        }

        RealCall get() {
            return RealCall.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeOn(ExecutorService executorService) {
            assert (!Thread.holdsLock(RealCall.this.client.dispatcher()));
            boolean bl = false;
            try {
                executorService.execute(this);
                bl = true;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                InterruptedIOException interruptedIOException = new InterruptedIOException("executor rejected");
                interruptedIOException.initCause(rejectedExecutionException);
                RealCall.this.transmitter.noMoreExchanges(interruptedIOException);
                this.responseCallback.onFailure(RealCall.this, interruptedIOException);
            }
            finally {
                if (!bl) {
                    RealCall.this.client.dispatcher().finished(this);
                }
            }
        }

        @Override
        protected void execute() {
            boolean bl = false;
            RealCall.this.transmitter.timeoutEnter();
            try {
                Response response = RealCall.this.getResponseWithInterceptorChain();
                bl = true;
                this.responseCallback.onResponse(RealCall.this, response);
            }
            catch (IOException iOException) {
                if (bl) {
                    Platform.get().log(4, "Callback failure for " + RealCall.this.toLoggableString(), iOException);
                } else {
                    this.responseCallback.onFailure(RealCall.this, iOException);
                }
            }
            catch (Throwable throwable) {
                RealCall.this.cancel();
                if (!bl) {
                    IOException iOException = new IOException("canceled due to " + throwable);
                    iOException.addSuppressed(throwable);
                    this.responseCallback.onFailure(RealCall.this, iOException);
                }
                throw throwable;
            }
            finally {
                RealCall.this.client.dispatcher().finished(this);
            }
        }
    }
}

