/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MediaType {
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    private final String mediaType;
    private final String type;
    private final String subtype;
    @Nullable
    private final String charset;

    private MediaType(String string, String string2, String string3, @Nullable String string4) {
        this.mediaType = string;
        this.type = string2;
        this.subtype = string3;
        this.charset = string4;
    }

    public static MediaType get(String string) {
        Matcher matcher = TYPE_SUBTYPE.matcher(string);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException("No subtype found for: \"" + string + '\"');
        }
        String string2 = matcher.group(1).toLowerCase(Locale.US);
        String string3 = matcher.group(2).toLowerCase(Locale.US);
        String string4 = null;
        Matcher matcher2 = PARAMETER.matcher(string);
        int n = matcher.end();
        while (n < string.length()) {
            matcher2.region(n, string.length());
            if (!matcher2.lookingAt()) {
                throw new IllegalArgumentException("Parameter is not formatted correctly: \"" + string.substring(n) + "\" for: \"" + string + '\"');
            }
            String string5 = matcher2.group(1);
            if (string5 != null && string5.equalsIgnoreCase("charset")) {
                String string6 = matcher2.group(2);
                String string7 = string6 != null ? (string6.startsWith("'") && string6.endsWith("'") && string6.length() > 2 ? string6.substring(1, string6.length() - 1) : string6) : matcher2.group(3);
                if (string4 != null && !string7.equalsIgnoreCase(string4)) {
                    throw new IllegalArgumentException("Multiple charsets defined: \"" + string4 + "\" and: \"" + string7 + "\" for: \"" + string + '\"');
                }
                string4 = string7;
            }
            n = matcher2.end();
        }
        return new MediaType(string, string2, string3, string4);
    }

    @Nullable
    public static MediaType parse(String string) {
        try {
            return MediaType.get(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    @Nullable
    public Charset charset() {
        return this.charset(null);
    }

    @Nullable
    public Charset charset(@Nullable Charset charset) {
        try {
            return this.charset != null ? Charset.forName(this.charset) : charset;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return charset;
        }
    }

    public String toString() {
        return this.mediaType;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof MediaType && ((MediaType)object).mediaType.equals(this.mediaType);
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }
}

