/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import okhttp3.internal.Util;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import okio.Buffer;

public final class HttpUrl {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    static final String QUERY_ENCODE_SET = " \"'<>#";
    static final String QUERY_COMPONENT_REENCODE_SET = " \"'<>#&=";
    static final String QUERY_COMPONENT_ENCODE_SET = " !\"#$&'(),/:;<=>?@[]\\^`{|}~";
    static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    static final String FRAGMENT_ENCODE_SET = "";
    static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    final String scheme;
    private final String username;
    private final String password;
    final String host;
    final int port;
    private final List<String> pathSegments;
    @Nullable
    private final List<String> queryNamesAndValues;
    @Nullable
    private final String fragment;
    private final String url;

    HttpUrl(Builder builder) {
        this.scheme = builder.scheme;
        this.username = HttpUrl.percentDecode(builder.encodedUsername, false);
        this.password = HttpUrl.percentDecode(builder.encodedPassword, false);
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.pathSegments = this.percentDecode(builder.encodedPathSegments, false);
        this.queryNamesAndValues = builder.encodedQueryNamesAndValues != null ? this.percentDecode(builder.encodedQueryNamesAndValues, true) : null;
        this.fragment = builder.encodedFragment != null ? HttpUrl.percentDecode(builder.encodedFragment, false) : null;
        this.url = builder.toString();
    }

    public URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public URI uri() {
        String string = this.newBuilder().reencodeForUri().toString();
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                String string2 = string.replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]", FRAGMENT_ENCODE_SET);
                return URI.create(string2);
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public String scheme() {
        return this.scheme;
    }

    public boolean isHttps() {
        return this.scheme.equals("https");
    }

    public String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n = this.scheme.length() + 3;
        int n2 = Util.delimiterOffset(this.url, n, this.url.length(), ":@");
        return this.url.substring(n, n2);
    }

    public String username() {
        return this.username;
    }

    public String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n = this.url.indexOf(58, this.scheme.length() + 3) + 1;
        int n2 = this.url.indexOf(64);
        return this.url.substring(n, n2);
    }

    public String password() {
        return this.password;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public static int defaultPort(String string) {
        if (string.equals("http")) {
            return 80;
        }
        if (string.equals("https")) {
            return 443;
        }
        return -1;
    }

    public int pathSize() {
        return this.pathSegments.size();
    }

    public String encodedPath() {
        int n = this.url.indexOf(47, this.scheme.length() + 3);
        int n2 = Util.delimiterOffset(this.url, n, this.url.length(), "?#");
        return this.url.substring(n, n2);
    }

    static void pathSegmentsToString(StringBuilder stringBuilder, List<String> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('/');
            stringBuilder.append(list.get(i));
        }
    }

    public List<String> encodedPathSegments() {
        int n = this.url.indexOf(47, this.scheme.length() + 3);
        int n2 = Util.delimiterOffset(this.url, n, this.url.length(), "?#");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n;
        while (n3 < n2) {
            int n4 = Util.delimiterOffset(this.url, ++n3, n2, '/');
            arrayList.add(this.url.substring(n3, n4));
            n3 = n4;
        }
        return arrayList;
    }

    public List<String> pathSegments() {
        return this.pathSegments;
    }

    @Nullable
    public String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n = this.url.indexOf(63) + 1;
        int n2 = Util.delimiterOffset(this.url, n, this.url.length(), '#');
        return this.url.substring(n, n2);
    }

    static void namesAndValuesToQueryString(StringBuilder stringBuilder, List<String> list) {
        int n = list.size();
        for (int i = 0; i < n; i += 2) {
            String string = list.get(i);
            String string2 = list.get(i + 1);
            if (i > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string);
            if (string2 == null) continue;
            stringBuilder.append('=');
            stringBuilder.append(string2);
        }
    }

    static List<String> queryStringToNamesAndValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n <= string.length()) {
            int n2;
            int n3 = string.indexOf(38, n);
            if (n3 == -1) {
                n3 = string.length();
            }
            if ((n2 = string.indexOf(61, n)) == -1 || n2 > n3) {
                arrayList.add(string.substring(n, n3));
                arrayList.add(null);
            } else {
                arrayList.add(string.substring(n, n2));
                arrayList.add(string.substring(n2 + 1, n3));
            }
            n = n3 + 1;
        }
        return arrayList;
    }

    @Nullable
    public String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpUrl.namesAndValuesToQueryString(stringBuilder, this.queryNamesAndValues);
        return stringBuilder.toString();
    }

    public int querySize() {
        return this.queryNamesAndValues != null ? this.queryNamesAndValues.size() / 2 : 0;
    }

    @Nullable
    public String queryParameter(String string) {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n = this.queryNamesAndValues.size();
        for (int i = 0; i < n; i += 2) {
            if (!string.equals(this.queryNamesAndValues.get(i))) continue;
            return this.queryNamesAndValues.get(i + 1);
        }
        return null;
    }

    public Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n = this.queryNamesAndValues.size();
        for (int i = 0; i < n; i += 2) {
            linkedHashSet.add(this.queryNamesAndValues.get(i));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public List<String> queryParameterValues(String string) {
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.queryNamesAndValues.size();
        for (int i = 0; i < n; i += 2) {
            if (!string.equals(this.queryNamesAndValues.get(i))) continue;
            arrayList.add(this.queryNamesAndValues.get(i + 1));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String queryParameterName(int n) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(n * 2);
    }

    public String queryParameterValue(int n) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(n * 2 + 1);
    }

    @Nullable
    public String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int n = this.url.indexOf(35) + 1;
        return this.url.substring(n);
    }

    @Nullable
    public String fragment() {
        return this.fragment;
    }

    public String redact() {
        return this.newBuilder("/...").username(FRAGMENT_ENCODE_SET).password(FRAGMENT_ENCODE_SET).build().toString();
    }

    @Nullable
    public HttpUrl resolve(String string) {
        Builder builder = this.newBuilder(string);
        return builder != null ? builder.build() : null;
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.scheme = this.scheme;
        builder.encodedUsername = this.encodedUsername();
        builder.encodedPassword = this.encodedPassword();
        builder.host = this.host;
        builder.port = this.port != HttpUrl.defaultPort(this.scheme) ? this.port : -1;
        builder.encodedPathSegments.clear();
        builder.encodedPathSegments.addAll(this.encodedPathSegments());
        builder.encodedQuery(this.encodedQuery());
        builder.encodedFragment = this.encodedFragment();
        return builder;
    }

    @Nullable
    public Builder newBuilder(String string) {
        try {
            return new Builder().parse(this, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Nullable
    public static HttpUrl parse(String string) {
        try {
            return HttpUrl.get(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static HttpUrl get(String string) {
        return new Builder().parse(null, string).build();
    }

    @Nullable
    public static HttpUrl get(URL uRL) {
        return HttpUrl.parse(uRL.toString());
    }

    @Nullable
    public static HttpUrl get(URI uRI) {
        return HttpUrl.parse(uRI.toString());
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof HttpUrl && ((HttpUrl)object).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    @Nullable
    public String topPrivateDomain() {
        if (Util.verifyAsIpAddress(this.host)) {
            return null;
        }
        return PublicSuffixDatabase.get().getEffectiveTldPlusOne(this.host);
    }

    static String percentDecode(String string, boolean bl) {
        return HttpUrl.percentDecode(string, 0, string.length(), bl);
    }

    private List<String> percentDecode(List<String> list, boolean bl) {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            arrayList.add(string != null ? HttpUrl.percentDecode(string, bl) : null);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static String percentDecode(String string, int n, int n2, boolean bl) {
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '%' && (c != '+' || !bl)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, n, i);
            HttpUrl.percentDecode(buffer, string, i, n2, bl);
            return buffer.readUtf8();
        }
        return string.substring(n, n2);
    }

    static void percentDecode(Buffer buffer, String string, int n, int n2, boolean bl) {
        int n3;
        for (int i = n; i < n2; i += Character.charCount(n3)) {
            n3 = string.codePointAt(i);
            if (n3 == 37 && i + 2 < n2) {
                int n4 = Util.decodeHexDigit(string.charAt(i + 1));
                int n5 = Util.decodeHexDigit(string.charAt(i + 2));
                if (n4 != -1 && n5 != -1) {
                    buffer.writeByte((n4 << 4) + n5);
                    i += 2;
                    continue;
                }
            } else if (n3 == 43 && bl) {
                buffer.writeByte(32);
                continue;
            }
            buffer.writeUtf8CodePoint(n3);
        }
    }

    static boolean percentEncoded(String string, int n, int n2) {
        return n + 2 < n2 && string.charAt(n) == '%' && Util.decodeHexDigit(string.charAt(n + 1)) != -1 && Util.decodeHexDigit(string.charAt(n + 2)) != -1;
    }

    static String canonicalize(String string, int n, int n2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, @Nullable Charset charset) {
        int n3;
        for (int i = n; i < n2; i += Character.charCount(n3)) {
            n3 = string.codePointAt(i);
            if (!(n3 < 32 || n3 == 127 || n3 >= 128 && bl4 || string2.indexOf(n3) != -1 || n3 == 37 && (!bl || bl2 && !HttpUrl.percentEncoded(string, i, n2))) && (n3 != 43 || !bl3)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, n, i);
            HttpUrl.canonicalize(buffer, string, i, n2, string2, bl, bl2, bl3, bl4, charset);
            return buffer.readUtf8();
        }
        return string.substring(n, n2);
    }

    static void canonicalize(Buffer buffer, String string, int n, int n2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, @Nullable Charset charset) {
        int n3;
        Buffer buffer2 = null;
        for (int i = n; i < n2; i += Character.charCount(n3)) {
            n3 = string.codePointAt(i);
            if (bl && (n3 == 9 || n3 == 10 || n3 == 12 || n3 == 13)) continue;
            if (n3 == 43 && bl3) {
                buffer.writeUtf8(bl ? "+" : "%2B");
                continue;
            }
            if (n3 < 32 || n3 == 127 || n3 >= 128 && bl4 || string2.indexOf(n3) != -1 || n3 == 37 && (!bl || bl2 && !HttpUrl.percentEncoded(string, i, n2))) {
                if (buffer2 == null) {
                    buffer2 = new Buffer();
                }
                if (charset == null || charset.equals(StandardCharsets.UTF_8)) {
                    buffer2.writeUtf8CodePoint(n3);
                } else {
                    buffer2.writeString(string, i, i + Character.charCount(n3), charset);
                }
                while (!buffer2.exhausted()) {
                    int n4 = buffer2.readByte() & 0xFF;
                    buffer.writeByte(37);
                    buffer.writeByte(HEX_DIGITS[n4 >> 4 & 0xF]);
                    buffer.writeByte(HEX_DIGITS[n4 & 0xF]);
                }
                continue;
            }
            buffer.writeUtf8CodePoint(n3);
        }
    }

    static String canonicalize(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, @Nullable Charset charset) {
        return HttpUrl.canonicalize(string, 0, string.length(), string2, bl, bl2, bl3, bl4, charset);
    }

    static String canonicalize(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return HttpUrl.canonicalize(string, 0, string.length(), string2, bl, bl2, bl3, bl4, null);
    }

    public static final class Builder {
        @Nullable
        String scheme;
        String encodedUsername = "";
        String encodedPassword = "";
        @Nullable
        String host;
        int port = -1;
        final List<String> encodedPathSegments = new ArrayList<String>();
        @Nullable
        List<String> encodedQueryNamesAndValues;
        @Nullable
        String encodedFragment;
        static final String INVALID_HOST = "Invalid URL host";

        public Builder() {
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        public Builder scheme(String string) {
            if (string == null) {
                throw new NullPointerException("scheme == null");
            }
            if (string.equalsIgnoreCase("http")) {
                this.scheme = "http";
            } else if (string.equalsIgnoreCase("https")) {
                this.scheme = "https";
            } else {
                throw new IllegalArgumentException("unexpected scheme: " + string);
            }
            return this;
        }

        public Builder username(String string) {
            if (string == null) {
                throw new NullPointerException("username == null");
            }
            this.encodedUsername = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public Builder encodedUsername(String string) {
            if (string == null) {
                throw new NullPointerException("encodedUsername == null");
            }
            this.encodedUsername = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder password(String string) {
            if (string == null) {
                throw new NullPointerException("password == null");
            }
            this.encodedPassword = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public Builder encodedPassword(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPassword == null");
            }
            this.encodedPassword = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder host(String string) {
            if (string == null) {
                throw new NullPointerException("host == null");
            }
            String string2 = Builder.canonicalizeHost(string, 0, string.length());
            if (string2 == null) {
                throw new IllegalArgumentException("unexpected host: " + string);
            }
            this.host = string2;
            return this;
        }

        public Builder port(int n) {
            if (n <= 0 || n > 65535) {
                throw new IllegalArgumentException("unexpected port: " + n);
            }
            this.port = n;
            return this;
        }

        int effectivePort() {
            return this.port != -1 ? this.port : HttpUrl.defaultPort(this.scheme);
        }

        public Builder addPathSegment(String string) {
            if (string == null) {
                throw new NullPointerException("pathSegment == null");
            }
            this.push(string, 0, string.length(), false, false);
            return this;
        }

        public Builder addPathSegments(String string) {
            if (string == null) {
                throw new NullPointerException("pathSegments == null");
            }
            return this.addPathSegments(string, false);
        }

        public Builder addEncodedPathSegment(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            this.push(string, 0, string.length(), false, true);
            return this;
        }

        public Builder addEncodedPathSegments(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPathSegments == null");
            }
            return this.addPathSegments(string, true);
        }

        private Builder addPathSegments(String string, boolean bl) {
            int n;
            int n2 = 0;
            do {
                boolean bl2 = (n = Util.delimiterOffset(string, n2, string.length(), "/\\")) < string.length();
                this.push(string, n2, n, bl2, bl);
            } while ((n2 = n + 1) <= string.length());
            return this;
        }

        public Builder setPathSegment(int n, String string) {
            if (string == null) {
                throw new NullPointerException("pathSegment == null");
            }
            String string2 = HttpUrl.canonicalize(string, 0, string.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, false, false, false, true, null);
            if (this.isDot(string2) || this.isDotDot(string2)) {
                throw new IllegalArgumentException("unexpected path segment: " + string);
            }
            this.encodedPathSegments.set(n, string2);
            return this;
        }

        public Builder setEncodedPathSegment(int n, String string) {
            if (string == null) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            String string2 = HttpUrl.canonicalize(string, 0, string.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, true, false, false, true, null);
            this.encodedPathSegments.set(n, string2);
            if (this.isDot(string2) || this.isDotDot(string2)) {
                throw new IllegalArgumentException("unexpected path segment: " + string);
            }
            return this;
        }

        public Builder removePathSegment(int n) {
            this.encodedPathSegments.remove(n);
            if (this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        public Builder encodedPath(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPath == null");
            }
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("unexpected encodedPath: " + string);
            }
            this.resolvePath(string, 0, string.length());
            return this;
        }

        public Builder query(@Nullable String string) {
            this.encodedQueryNamesAndValues = string != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, HttpUrl.QUERY_ENCODE_SET, false, false, true, true)) : null;
            return this;
        }

        public Builder encodedQuery(@Nullable String string) {
            this.encodedQueryNamesAndValues = string != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, HttpUrl.QUERY_ENCODE_SET, true, false, true, true)) : null;
            return this;
        }

        public Builder addQueryParameter(String string, @Nullable String string2) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
            this.encodedQueryNamesAndValues.add(string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true) : null);
            return this;
        }

        public Builder addEncodedQueryParameter(String string, @Nullable String string2) {
            if (string == null) {
                throw new NullPointerException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            this.encodedQueryNamesAndValues.add(string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true) : null);
            return this;
        }

        public Builder setQueryParameter(String string, @Nullable String string2) {
            this.removeAllQueryParameters(string);
            this.addQueryParameter(string, string2);
            return this;
        }

        public Builder setEncodedQueryParameter(String string, @Nullable String string2) {
            this.removeAllEncodedQueryParameters(string);
            this.addEncodedQueryParameter(string, string2);
            return this;
        }

        public Builder removeAllQueryParameters(String string) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            String string2 = HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true);
            this.removeAllCanonicalQueryParameters(string2);
            return this;
        }

        public Builder removeAllEncodedQueryParameters(String string) {
            if (string == null) {
                throw new NullPointerException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            return this;
        }

        private void removeAllCanonicalQueryParameters(String string) {
            for (int i = this.encodedQueryNamesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!string.equals(this.encodedQueryNamesAndValues.get(i))) continue;
                this.encodedQueryNamesAndValues.remove(i + 1);
                this.encodedQueryNamesAndValues.remove(i);
                if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        public Builder fragment(@Nullable String string) {
            this.encodedFragment = string != null ? HttpUrl.canonicalize(string, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, false) : null;
            return this;
        }

        public Builder encodedFragment(@Nullable String string) {
            this.encodedFragment = string != null ? HttpUrl.canonicalize(string, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false) : null;
            return this;
        }

        Builder reencodeForUri() {
            String string;
            int n;
            int n2 = this.encodedPathSegments.size();
            for (n = 0; n < n2; ++n) {
                string = this.encodedPathSegments.get(n);
                this.encodedPathSegments.set(n, HttpUrl.canonicalize(string, HttpUrl.PATH_SEGMENT_ENCODE_SET_URI, true, true, false, true));
            }
            if (this.encodedQueryNamesAndValues != null) {
                n2 = this.encodedQueryNamesAndValues.size();
                for (n = 0; n < n2; ++n) {
                    string = this.encodedQueryNamesAndValues.get(n);
                    if (string == null) continue;
                    this.encodedQueryNamesAndValues.set(n, HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_ENCODE_SET_URI, true, true, true, true));
                }
            }
            if (this.encodedFragment != null) {
                this.encodedFragment = HttpUrl.canonicalize(this.encodedFragment, HttpUrl.FRAGMENT_ENCODE_SET_URI, true, true, false, false);
            }
            return this;
        }

        public HttpUrl build() {
            if (this.scheme == null) {
                throw new IllegalStateException("scheme == null");
            }
            if (this.host == null) {
                throw new IllegalStateException("host == null");
            }
            return new HttpUrl(this);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.scheme != null) {
                stringBuilder.append(this.scheme);
                stringBuilder.append("://");
            } else {
                stringBuilder.append("//");
            }
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                stringBuilder.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.encodedPassword);
                }
                stringBuilder.append('@');
            }
            if (this.host != null) {
                if (this.host.indexOf(58) != -1) {
                    stringBuilder.append('[');
                    stringBuilder.append(this.host);
                    stringBuilder.append(']');
                } else {
                    stringBuilder.append(this.host);
                }
            }
            if (this.port != -1 || this.scheme != null) {
                int n = this.effectivePort();
                if (this.scheme == null || n != HttpUrl.defaultPort(this.scheme)) {
                    stringBuilder.append(':');
                    stringBuilder.append(n);
                }
            }
            HttpUrl.pathSegmentsToString(stringBuilder, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                stringBuilder.append('?');
                HttpUrl.namesAndValuesToQueryString(stringBuilder, this.encodedQueryNamesAndValues);
            }
            if (this.encodedFragment != null) {
                stringBuilder.append('#');
                stringBuilder.append(this.encodedFragment);
            }
            return stringBuilder.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Builder parse(@Nullable HttpUrl httpUrl, String string) {
            int n;
            int n2;
            int n3;
            int n4;
            block19: {
                n4 = Util.skipLeadingAsciiWhitespace(string, 0, string.length());
                int n5 = Builder.schemeDelimiterOffset(string, n4, n3 = Util.skipTrailingAsciiWhitespace(string, n4, string.length()));
                if (n5 != -1) {
                    if (string.regionMatches(true, n4, "https:", 0, 6)) {
                        this.scheme = "https";
                        n4 += "https:".length();
                    } else {
                        if (!string.regionMatches(true, n4, "http:", 0, 5)) throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but was '" + string.substring(0, n5) + "'");
                        this.scheme = "http";
                        n4 += "http:".length();
                    }
                } else {
                    if (httpUrl == null) throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no colon was found");
                    this.scheme = httpUrl.scheme;
                }
                boolean bl = false;
                boolean bl2 = false;
                int n6 = Builder.slashCount(string, n4, n3);
                if (n6 >= 2 || httpUrl == null || !httpUrl.scheme.equals(this.scheme)) {
                    n4 += n6;
                    while (true) {
                        n = (n2 = Util.delimiterOffset(string, n4, n3, "@/\\?#")) != n3 ? (int)string.charAt(n2) : -1;
                        switch (n) {
                            case 64: {
                                int n7;
                                if (!bl2) {
                                    n7 = Util.delimiterOffset(string, n4, n2, ':');
                                    String string2 = HttpUrl.canonicalize(string, n4, n7, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    String string3 = this.encodedUsername = bl ? this.encodedUsername + "%40" + string2 : string2;
                                    if (n7 != n2) {
                                        bl2 = true;
                                        this.encodedPassword = HttpUrl.canonicalize(string, n7 + 1, n2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    }
                                    bl = true;
                                } else {
                                    this.encodedPassword = this.encodedPassword + "%40" + HttpUrl.canonicalize(string, n4, n2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                }
                                n4 = n2 + 1;
                                break;
                            }
                            case -1: 
                            case 35: 
                            case 47: 
                            case 63: 
                            case 92: {
                                int n7 = Builder.portColonOffset(string, n4, n2);
                                if (n7 + 1 < n2) {
                                    this.host = Builder.canonicalizeHost(string, n4, n7);
                                    this.port = Builder.parsePort(string, n7 + 1, n2);
                                    if (this.port == -1) {
                                        throw new IllegalArgumentException("Invalid URL port: \"" + string.substring(n7 + 1, n2) + '\"');
                                    }
                                } else {
                                    this.host = Builder.canonicalizeHost(string, n4, n7);
                                    this.port = HttpUrl.defaultPort(this.scheme);
                                }
                                if (this.host == null) {
                                    throw new IllegalArgumentException("Invalid URL host: \"" + string.substring(n4, n7) + '\"');
                                }
                                n4 = n2;
                                break block19;
                            }
                        }
                    }
                }
                this.encodedUsername = httpUrl.encodedUsername();
                this.encodedPassword = httpUrl.encodedPassword();
                this.host = httpUrl.host;
                this.port = httpUrl.port;
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll(httpUrl.encodedPathSegments());
                if (n4 == n3 || string.charAt(n4) == '#') {
                    this.encodedQuery(httpUrl.encodedQuery());
                }
            }
            n2 = Util.delimiterOffset(string, n4, n3, "?#");
            this.resolvePath(string, n4, n2);
            n4 = n2;
            if (n4 < n3 && string.charAt(n4) == '?') {
                n = Util.delimiterOffset(string, n4, n3, '#');
                this.encodedQueryNamesAndValues = HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, n4 + 1, n, HttpUrl.QUERY_ENCODE_SET, true, false, true, true, null));
                n4 = n;
            }
            if (n4 >= n3 || string.charAt(n4) != '#') return this;
            this.encodedFragment = HttpUrl.canonicalize(string, n4 + 1, n3, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false, null);
            return this;
        }

        private void resolvePath(String string, int n, int n2) {
            if (n == n2) {
                return;
            }
            char c = string.charAt(n);
            if (c == '/' || c == '\\') {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
                ++n;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            }
            int n3 = n;
            while (n3 < n2) {
                int n4 = Util.delimiterOffset(string, n3, n2, "/\\");
                boolean bl = n4 < n2;
                this.push(string, n3, n4, bl, true);
                n3 = n4;
                if (!bl) continue;
                ++n3;
            }
        }

        private void push(String string, int n, int n2, boolean bl, boolean bl2) {
            String string2 = HttpUrl.canonicalize(string, n, n2, HttpUrl.PATH_SEGMENT_ENCODE_SET, bl2, false, false, true, null);
            if (this.isDot(string2)) {
                return;
            }
            if (this.isDotDot(string2)) {
                this.pop();
                return;
            }
            if (this.encodedPathSegments.get(this.encodedPathSegments.size() - 1).isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, string2);
            } else {
                this.encodedPathSegments.add(string2);
            }
            if (bl) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private boolean isDot(String string) {
            return string.equals(".") || string.equalsIgnoreCase("%2e");
        }

        private boolean isDotDot(String string) {
            return string.equals("..") || string.equalsIgnoreCase("%2e.") || string.equalsIgnoreCase(".%2e") || string.equalsIgnoreCase("%2e%2e");
        }

        private void pop() {
            String string = this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1);
            if (string.isEmpty() && !this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            } else {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private static int schemeDelimiterOffset(String string, int n, int n2) {
            if (n2 - n < 2) {
                return -1;
            }
            char c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                return -1;
            }
            for (int i = n + 1; i < n2; ++i) {
                char c2 = string.charAt(i);
                if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '+' || c2 == '-' || c2 == '.') continue;
                if (c2 == ':') {
                    return i;
                }
                return -1;
            }
            return -1;
        }

        private static int slashCount(String string, int n, int n2) {
            char c;
            int n3 = 0;
            while (n < n2 && ((c = string.charAt(n)) == '\\' || c == '/')) {
                ++n3;
                ++n;
            }
            return n3;
        }

        private static int portColonOffset(String string, int n, int n2) {
            block4: for (int i = n; i < n2; ++i) {
                switch (string.charAt(i)) {
                    case '[': {
                        while (++i < n2 && string.charAt(i) != ']') {
                        }
                        continue block4;
                    }
                    case ':': {
                        return i;
                    }
                }
            }
            return n2;
        }

        @Nullable
        private static String canonicalizeHost(String string, int n, int n2) {
            String string2 = HttpUrl.percentDecode(string, n, n2, false);
            return Util.canonicalizeHost(string2);
        }

        private static int parsePort(String string, int n, int n2) {
            try {
                String string2 = HttpUrl.canonicalize(string, n, n2, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, true, null);
                int n3 = Integer.parseInt(string2);
                if (n3 > 0 && n3 <= 65535) {
                    return n3;
                }
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
    }
}

