/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class Headers {
    private final String[] namesAndValues;

    Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] stringArray) {
        this.namesAndValues = stringArray;
    }

    @Nullable
    public String get(String string) {
        return Headers.get(this.namesAndValues, string);
    }

    @Nullable
    public Date getDate(String string) {
        String string2 = this.get(string);
        return string2 != null ? HttpDate.parse(string2) : null;
    }

    @Nullable
    @IgnoreJRERequirement
    public Instant getInstant(String string) {
        Date date = this.getDate(string);
        return date != null ? date.toInstant() : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int n) {
        return this.namesAndValues[n * 2];
    }

    public String value(int n) {
        return this.namesAndValues[n * 2 + 1];
    }

    public Set<String> names() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            treeSet.add(this.name(i));
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public List<String> values(String string) {
        ArrayList<String> arrayList = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(this.name(i))) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
            }
            arrayList.add(this.value(i));
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public long byteCount() {
        long l = this.namesAndValues.length * 2;
        int n = this.namesAndValues.length;
        for (int i = 0; i < n; ++i) {
            l += (long)this.namesAndValues[i].length();
        }
        return l;
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        Collections.addAll(builder.namesAndValues, this.namesAndValues);
        return builder;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof Headers && Arrays.equals(((Headers)object).namesAndValues, this.namesAndValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.name(i)).append(": ").append(this.value(i)).append("\n");
        }
        return stringBuilder.toString();
    }

    public Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            String string = this.name(i).toLowerCase(Locale.US);
            ArrayList<String> arrayList = (ArrayList<String>)treeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
                treeMap.put(string, arrayList);
            }
            arrayList.add(this.value(i));
        }
        return treeMap;
    }

    @Nullable
    private static String get(String[] stringArray, String string) {
        for (int i = stringArray.length - 2; i >= 0; i -= 2) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public static Headers of(String ... stringArray) {
        int n;
        if (stringArray == null) {
            throw new NullPointerException("namesAndValues == null");
        }
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        stringArray = (String[])stringArray.clone();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            stringArray[n] = stringArray[n].trim();
        }
        for (n = 0; n < stringArray.length; n += 2) {
            String string = stringArray[n];
            String string2 = stringArray[n + 1];
            Headers.checkName(string);
            Headers.checkValue(string2, string);
        }
        return new Headers(stringArray);
    }

    public static Headers of(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("headers == null");
        }
        String[] stringArray = new String[map.size() * 2];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            String string = entry.getKey().trim();
            String string2 = entry.getValue().trim();
            Headers.checkName(string);
            Headers.checkValue(string2, string);
            stringArray[n] = string;
            stringArray[n + 1] = string2;
            n += 2;
        }
        return new Headers(stringArray);
    }

    static void checkName(String string) {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in header name: %s", c, i, string));
        }
    }

    static void checkValue(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("value for name " + string2 + " == null");
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ((c > '\u001f' || c == '\t') && c < '\u007f') continue;
            throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in %s value: %s", c, i, string2, string));
        }
    }

    public static final class Builder {
        final List<String> namesAndValues = new ArrayList<String>(20);

        Builder addLenient(String string) {
            int n = string.indexOf(":", 1);
            if (n != -1) {
                return this.addLenient(string.substring(0, n), string.substring(n + 1));
            }
            if (string.startsWith(":")) {
                return this.addLenient("", string.substring(1));
            }
            return this.addLenient("", string);
        }

        public Builder add(String string) {
            int n = string.indexOf(":");
            if (n == -1) {
                throw new IllegalArgumentException("Unexpected header: " + string);
            }
            return this.add(string.substring(0, n).trim(), string.substring(n + 1));
        }

        public Builder add(String string, String string2) {
            Headers.checkName(string);
            Headers.checkValue(string2, string);
            return this.addLenient(string, string2);
        }

        public Builder addUnsafeNonAscii(String string, String string2) {
            Headers.checkName(string);
            return this.addLenient(string, string2);
        }

        public Builder addAll(Headers headers) {
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                this.addLenient(headers.name(i), headers.value(i));
            }
            return this;
        }

        public Builder add(String string, Date date) {
            if (date == null) {
                throw new NullPointerException("value for name " + string + " == null");
            }
            this.add(string, HttpDate.format(date));
            return this;
        }

        @IgnoreJRERequirement
        public Builder add(String string, Instant instant) {
            if (instant == null) {
                throw new NullPointerException("value for name " + string + " == null");
            }
            return this.add(string, new Date(instant.toEpochMilli()));
        }

        public Builder set(String string, Date date) {
            if (date == null) {
                throw new NullPointerException("value for name " + string + " == null");
            }
            this.set(string, HttpDate.format(date));
            return this;
        }

        @IgnoreJRERequirement
        public Builder set(String string, Instant instant) {
            if (instant == null) {
                throw new NullPointerException("value for name " + string + " == null");
            }
            return this.set(string, new Date(instant.toEpochMilli()));
        }

        Builder addLenient(String string, String string2) {
            this.namesAndValues.add(string);
            this.namesAndValues.add(string2.trim());
            return this;
        }

        public Builder removeAll(String string) {
            for (int i = 0; i < this.namesAndValues.size(); i += 2) {
                if (!string.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                this.namesAndValues.remove(i);
                this.namesAndValues.remove(i);
                i -= 2;
            }
            return this;
        }

        public Builder set(String string, String string2) {
            Headers.checkName(string);
            Headers.checkValue(string2, string);
            this.removeAll(string);
            this.addLenient(string, string2);
            return this;
        }

        @Nullable
        public String get(String string) {
            for (int i = this.namesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!string.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                return this.namesAndValues.get(i + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

