/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;

public final class Handshake {
    private final TlsVersion tlsVersion;
    private final CipherSuite cipherSuite;
    private final List<Certificate> peerCertificates;
    private final List<Certificate> localCertificates;

    private Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.peerCertificates = list;
        this.localCertificates = list2;
    }

    public static Handshake get(SSLSession sSLSession) throws IOException {
        Certificate[] certificateArray;
        String string = sSLSession.getCipherSuite();
        if (string == null) {
            throw new IllegalStateException("cipherSuite == null");
        }
        if ("SSL_NULL_WITH_NULL_NULL".equals(string)) {
            throw new IOException("cipherSuite == SSL_NULL_WITH_NULL_NULL");
        }
        CipherSuite cipherSuite = CipherSuite.forJavaName(string);
        String string2 = sSLSession.getProtocol();
        if (string2 == null) {
            throw new IllegalStateException("tlsVersion == null");
        }
        if ("NONE".equals(string2)) {
            throw new IOException("tlsVersion == NONE");
        }
        TlsVersion tlsVersion = TlsVersion.forJavaName(string2);
        try {
            certificateArray = sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            certificateArray = null;
        }
        List<Certificate> list = certificateArray != null ? Util.immutableList(certificateArray) : Collections.emptyList();
        Certificate[] certificateArray2 = sSLSession.getLocalCertificates();
        List<Certificate> list2 = certificateArray2 != null ? Util.immutableList(certificateArray2) : Collections.emptyList();
        return new Handshake(tlsVersion, cipherSuite, list, list2);
    }

    public static Handshake get(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        if (tlsVersion == null) {
            throw new NullPointerException("tlsVersion == null");
        }
        if (cipherSuite == null) {
            throw new NullPointerException("cipherSuite == null");
        }
        return new Handshake(tlsVersion, cipherSuite, Util.immutableList(list), Util.immutableList(list2));
    }

    public TlsVersion tlsVersion() {
        return this.tlsVersion;
    }

    public CipherSuite cipherSuite() {
        return this.cipherSuite;
    }

    public List<Certificate> peerCertificates() {
        return this.peerCertificates;
    }

    @Nullable
    public Principal peerPrincipal() {
        return !this.peerCertificates.isEmpty() ? ((X509Certificate)this.peerCertificates.get(0)).getSubjectX500Principal() : null;
    }

    public List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    @Nullable
    public Principal localPrincipal() {
        return !this.localCertificates.isEmpty() ? ((X509Certificate)this.localCertificates.get(0)).getSubjectX500Principal() : null;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Handshake)) {
            return false;
        }
        Handshake handshake = (Handshake)object;
        return this.tlsVersion.equals((Object)handshake.tlsVersion) && this.cipherSuite.equals(handshake.cipherSuite) && this.peerCertificates.equals(handshake.peerCertificates) && this.localCertificates.equals(handshake.localCertificates);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.tlsVersion.hashCode();
        n = 31 * n + this.cipherSuite.hashCode();
        n = 31 * n + this.peerCertificates.hashCode();
        n = 31 * n + this.localCertificates.hashCode();
        return n;
    }

    public String toString() {
        return "Handshake{tlsVersion=" + (Object)((Object)this.tlsVersion) + " cipherSuite=" + this.cipherSuite + " peerCertificates=" + this.names(this.peerCertificates) + " localCertificates=" + this.names(this.localCertificates) + '}';
    }

    private List<String> names(List<Certificate> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Certificate certificate : list) {
            if (certificate instanceof X509Certificate) {
                arrayList.add(String.valueOf(((X509Certificate)certificate).getSubjectDN()));
                continue;
            }
            arrayList.add(certificate.getType());
        }
        return arrayList;
    }
}

