/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.RealCall;
import okhttp3.internal.Util;

public final class Dispatcher {
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    @Nullable
    private Runnable idleCallback;
    @Nullable
    private ExecutorService executorService;
    private final Deque<RealCall.AsyncCall> readyAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall.AsyncCall> runningAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall> runningSyncCalls = new ArrayDeque<RealCall>();

    public Dispatcher(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Dispatcher() {
    }

    public synchronized ExecutorService executorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Dispatcher", false));
        }
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRequests(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("max < 1: " + n);
        }
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            this.maxRequests = n;
        }
        this.promoteAndExecute();
    }

    public synchronized int getMaxRequests() {
        return this.maxRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRequestsPerHost(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("max < 1: " + n);
        }
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            this.maxRequestsPerHost = n;
        }
        this.promoteAndExecute();
    }

    public synchronized int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    public synchronized void setIdleCallback(@Nullable Runnable runnable) {
        this.idleCallback = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(RealCall.AsyncCall asyncCall) {
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            RealCall.AsyncCall asyncCall2;
            this.readyAsyncCalls.add(asyncCall);
            if (!asyncCall.get().forWebSocket && (asyncCall2 = this.findExistingCallWithHost(asyncCall.host())) != null) {
                asyncCall.reuseCallsPerHostFrom(asyncCall2);
            }
        }
        this.promoteAndExecute();
    }

    @Nullable
    private RealCall.AsyncCall findExistingCallWithHost(String string) {
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            if (!asyncCall.host().equals(string)) continue;
            return asyncCall;
        }
        for (RealCall.AsyncCall asyncCall : this.readyAsyncCalls) {
            if (!asyncCall.host().equals(string)) continue;
            return asyncCall;
        }
        return null;
    }

    public synchronized void cancelAll() {
        for (RealCall.AsyncCall object : this.readyAsyncCalls) {
            object.get().cancel();
        }
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            asyncCall.get().cancel();
        }
        for (RealCall realCall : this.runningSyncCalls) {
            realCall.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean promoteAndExecute() {
        boolean bl;
        RealCall.AsyncCall asyncCall;
        assert (!Thread.holdsLock(this));
        ArrayList<RealCall.AsyncCall> arrayList = new ArrayList<RealCall.AsyncCall>();
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Iterator<RealCall.AsyncCall> iterator = this.readyAsyncCalls.iterator();
            while (iterator.hasNext()) {
                asyncCall = iterator.next();
                if (this.runningAsyncCalls.size() >= this.maxRequests) break;
                if (asyncCall.callsPerHost().get() >= this.maxRequestsPerHost) continue;
                iterator.remove();
                asyncCall.callsPerHost().incrementAndGet();
                arrayList.add(asyncCall);
                this.runningAsyncCalls.add(asyncCall);
            }
            bl = this.runningCallsCount() > 0;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            asyncCall = (RealCall.AsyncCall)arrayList.get(i);
            asyncCall.executeOn(this.executorService());
        }
        return bl;
    }

    synchronized void executed(RealCall realCall) {
        this.runningSyncCalls.add(realCall);
    }

    void finished(RealCall.AsyncCall asyncCall) {
        asyncCall.callsPerHost().decrementAndGet();
        this.finished(this.runningAsyncCalls, asyncCall);
    }

    void finished(RealCall realCall) {
        this.finished(this.runningSyncCalls, realCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void finished(Deque<T> deque, T t) {
        Runnable runnable;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (!deque.remove(t)) {
                throw new AssertionError((Object)"Call wasn't in-flight!");
            }
            runnable = this.idleCallback;
        }
        boolean bl = this.promoteAndExecute();
        if (!bl && runnable != null) {
            runnable.run();
        }
    }

    public synchronized List<Call> queuedCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        for (RealCall.AsyncCall asyncCall : this.readyAsyncCalls) {
            arrayList.add(asyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public synchronized List<Call> runningCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        arrayList.addAll(this.runningSyncCalls);
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            arrayList.add(asyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public synchronized int queuedCallsCount() {
        return this.readyAsyncCalls.size();
    }

    public synchronized int runningCallsCount() {
        return this.runningAsyncCalls.size() + this.runningSyncCalls.size();
    }
}

