/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;

public final class Cookie {
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;

    private Cookie(String string, String string2, long l, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string;
        this.value = string2;
        this.expiresAt = l;
        this.domain = string3;
        this.path = string4;
        this.secure = bl;
        this.httpOnly = bl2;
        this.hostOnly = bl3;
        this.persistent = bl4;
    }

    Cookie(Builder builder) {
        if (builder.name == null) {
            throw new NullPointerException("builder.name == null");
        }
        if (builder.value == null) {
            throw new NullPointerException("builder.value == null");
        }
        if (builder.domain == null) {
            throw new NullPointerException("builder.domain == null");
        }
        this.name = builder.name;
        this.value = builder.value;
        this.expiresAt = builder.expiresAt;
        this.domain = builder.domain;
        this.path = builder.path;
        this.secure = builder.secure;
        this.httpOnly = builder.httpOnly;
        this.persistent = builder.persistent;
        this.hostOnly = builder.hostOnly;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public long expiresAt() {
        return this.expiresAt;
    }

    public boolean hostOnly() {
        return this.hostOnly;
    }

    public String domain() {
        return this.domain;
    }

    public String path() {
        return this.path;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public boolean secure() {
        return this.secure;
    }

    public boolean matches(HttpUrl httpUrl) {
        boolean bl;
        boolean bl2 = bl = this.hostOnly ? httpUrl.host().equals(this.domain) : Cookie.domainMatch(httpUrl.host(), this.domain);
        if (!bl) {
            return false;
        }
        if (!Cookie.pathMatch(httpUrl, this.path)) {
            return false;
        }
        return !this.secure || httpUrl.isHttps();
    }

    private static boolean domainMatch(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return string.endsWith(string2) && string.charAt(string.length() - string2.length() - 1) == '.' && !Util.verifyAsIpAddress(string);
    }

    private static boolean pathMatch(HttpUrl httpUrl, String string) {
        String string2 = httpUrl.encodedPath();
        if (string2.equals(string)) {
            return true;
        }
        if (string2.startsWith(string)) {
            if (string.endsWith("/")) {
                return true;
            }
            if (string2.charAt(string.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Cookie parse(HttpUrl httpUrl, String string) {
        return Cookie.parse(System.currentTimeMillis(), httpUrl, string);
    }

    @Nullable
    static Cookie parse(long l, HttpUrl httpUrl, String string) {
        long l2;
        int n = 0;
        int n2 = string.length();
        int n3 = Util.delimiterOffset(string, n, n2, ';');
        int n4 = Util.delimiterOffset(string, n, n3, '=');
        if (n4 == n3) {
            return null;
        }
        String string2 = Util.trimSubstring(string, n, n4);
        if (string2.isEmpty() || Util.indexOfControlOrNonAscii(string2) != -1) {
            return null;
        }
        String string3 = Util.trimSubstring(string, n4 + 1, n3);
        if (Util.indexOfControlOrNonAscii(string3) != -1) {
            return null;
        }
        long l3 = 253402300799999L;
        long l4 = -1L;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        n = n3 + 1;
        while (n < n2) {
            String string6;
            int n5 = Util.delimiterOffset(string, n, n2, ';');
            int n6 = Util.delimiterOffset(string, n, n5, '=');
            String string7 = Util.trimSubstring(string, n, n6);
            String string8 = string6 = n6 < n5 ? Util.trimSubstring(string, n6 + 1, n5) : "";
            if (string7.equalsIgnoreCase("expires")) {
                try {
                    l3 = Cookie.parseExpires(string6, 0, string6.length());
                    bl4 = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase("max-age")) {
                try {
                    l4 = Cookie.parseMaxAge(string6);
                    bl4 = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string7.equalsIgnoreCase("domain")) {
                try {
                    string4 = Cookie.parseDomain(string6);
                    bl3 = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase("path")) {
                string5 = string6;
            } else if (string7.equalsIgnoreCase("secure")) {
                bl = true;
            } else if (string7.equalsIgnoreCase("httponly")) {
                bl2 = true;
            }
            n = n5 + 1;
        }
        if (l4 == Long.MIN_VALUE) {
            l3 = Long.MIN_VALUE;
        } else if (l4 != -1L && ((l3 = l + (l2 = l4 <= 9223372036854775L ? l4 * 1000L : Long.MAX_VALUE)) < l || l3 > 253402300799999L)) {
            l3 = 253402300799999L;
        }
        String string9 = httpUrl.host();
        if (string4 == null) {
            string4 = string9;
        } else if (!Cookie.domainMatch(string9, string4)) {
            return null;
        }
        if (string9.length() != string4.length() && PublicSuffixDatabase.get().getEffectiveTldPlusOne(string4) == null) {
            return null;
        }
        if (string5 == null || !string5.startsWith("/")) {
            String string10 = httpUrl.encodedPath();
            int n7 = string10.lastIndexOf(47);
            string5 = n7 != 0 ? string10.substring(0, n7) : "/";
        }
        return new Cookie(string2, string3, l3, string4, string5, bl, bl2, bl3, bl4);
    }

    private static long parseExpires(String string, int n, int n2) {
        n = Cookie.dateCharacterOffset(string, n, n2, false);
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        Matcher matcher = TIME_PATTERN.matcher(string);
        while (n < n2) {
            int n9 = Cookie.dateCharacterOffset(string, n + 1, n2, true);
            matcher.region(n, n9);
            if (n3 == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                n3 = Integer.parseInt(matcher.group(1));
                n4 = Integer.parseInt(matcher.group(2));
                n5 = Integer.parseInt(matcher.group(3));
            } else if (n6 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                n6 = Integer.parseInt(matcher.group(1));
            } else if (n7 == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                String string2 = matcher.group(1).toLowerCase(Locale.US);
                n7 = MONTH_PATTERN.pattern().indexOf(string2) / 4;
            } else if (n8 == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                n8 = Integer.parseInt(matcher.group(1));
            }
            n = Cookie.dateCharacterOffset(string, n9 + 1, n2, false);
        }
        if (n8 >= 70 && n8 <= 99) {
            n8 += 1900;
        }
        if (n8 >= 0 && n8 <= 69) {
            n8 += 2000;
        }
        if (n8 < 1601) {
            throw new IllegalArgumentException();
        }
        if (n7 == -1) {
            throw new IllegalArgumentException();
        }
        if (n6 < 1 || n6 > 31) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || n3 > 23) {
            throw new IllegalArgumentException();
        }
        if (n4 < 0 || n4 > 59) {
            throw new IllegalArgumentException();
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Util.UTC);
        gregorianCalendar.setLenient(false);
        gregorianCalendar.set(1, n8);
        gregorianCalendar.set(2, n7 - 1);
        gregorianCalendar.set(5, n6);
        gregorianCalendar.set(11, n3);
        gregorianCalendar.set(12, n4);
        gregorianCalendar.set(13, n5);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    private static int dateCharacterOffset(String string, int n, int n2, boolean bl) {
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            boolean bl2 = c < ' ' && c != '\t' || c >= '\u007f' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':';
            if (bl2 != !bl) continue;
            return i;
        }
        return n2;
    }

    private static long parseMaxAge(String string) {
        try {
            long l = Long.parseLong(string);
            return l <= 0L ? Long.MIN_VALUE : l;
        }
        catch (NumberFormatException numberFormatException) {
            if (string.matches("-?\\d+")) {
                return string.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            throw numberFormatException;
        }
    }

    private static String parseDomain(String string) {
        String string2;
        if (string.endsWith(".")) {
            throw new IllegalArgumentException();
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if ((string2 = Util.canonicalizeHost(string)) == null) {
            throw new IllegalArgumentException();
        }
        return string2;
    }

    public static List<Cookie> parseAll(HttpUrl httpUrl, Headers headers) {
        List<String> list = headers.values("Set-Cookie");
        ArrayList<Cookie> arrayList = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Cookie cookie = Cookie.parse(httpUrl, list.get(i));
            if (cookie == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Cookie>();
            }
            arrayList.add(cookie);
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append('=');
        stringBuilder.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                stringBuilder.append("; max-age=0");
            } else {
                stringBuilder.append("; expires=").append(HttpDate.format(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            stringBuilder.append("; domain=");
            if (bl) {
                stringBuilder.append(".");
            }
            stringBuilder.append(this.domain);
        }
        stringBuilder.append("; path=").append(this.path);
        if (this.secure) {
            stringBuilder.append("; secure");
        }
        if (this.httpOnly) {
            stringBuilder.append("; httponly");
        }
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)object;
        return cookie.name.equals(this.name) && cookie.value.equals(this.value) && cookie.domain.equals(this.domain) && cookie.path.equals(this.path) && cookie.expiresAt == this.expiresAt && cookie.secure == this.secure && cookie.httpOnly == this.httpOnly && cookie.persistent == this.persistent && cookie.hostOnly == this.hostOnly;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.value.hashCode();
        n = 31 * n + this.domain.hashCode();
        n = 31 * n + this.path.hashCode();
        n = 31 * n + (int)(this.expiresAt ^ this.expiresAt >>> 32);
        n = 31 * n + (this.secure ? 0 : 1);
        n = 31 * n + (this.httpOnly ? 0 : 1);
        n = 31 * n + (this.persistent ? 0 : 1);
        n = 31 * n + (this.hostOnly ? 0 : 1);
        return n;
    }

    public static final class Builder {
        @Nullable
        String name;
        @Nullable
        String value;
        long expiresAt = 253402300799999L;
        @Nullable
        String domain;
        String path = "/";
        boolean secure;
        boolean httpOnly;
        boolean persistent;
        boolean hostOnly;

        public Builder name(String string) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (!string.trim().equals(string)) {
                throw new IllegalArgumentException("name is not trimmed");
            }
            this.name = string;
            return this;
        }

        public Builder value(String string) {
            if (string == null) {
                throw new NullPointerException("value == null");
            }
            if (!string.trim().equals(string)) {
                throw new IllegalArgumentException("value is not trimmed");
            }
            this.value = string;
            return this;
        }

        public Builder expiresAt(long l) {
            if (l <= 0L) {
                l = Long.MIN_VALUE;
            }
            if (l > 253402300799999L) {
                l = 253402300799999L;
            }
            this.expiresAt = l;
            this.persistent = true;
            return this;
        }

        public Builder domain(String string) {
            return this.domain(string, false);
        }

        public Builder hostOnlyDomain(String string) {
            return this.domain(string, true);
        }

        private Builder domain(String string, boolean bl) {
            if (string == null) {
                throw new NullPointerException("domain == null");
            }
            String string2 = Util.canonicalizeHost(string);
            if (string2 == null) {
                throw new IllegalArgumentException("unexpected domain: " + string);
            }
            this.domain = string2;
            this.hostOnly = bl;
            return this;
        }

        public Builder path(String string) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("path must start with '/'");
            }
            this.path = string;
            return this;
        }

        public Builder secure() {
            this.secure = true;
            return this;
        }

        public Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public Cookie build() {
            return new Cookie(this);
        }
    }
}

