/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public final class Challenge {
    private final String scheme;
    private final Map<String, String> authParams;

    public Challenge(String string, Map<String, String> map) {
        if (string == null) {
            throw new NullPointerException("scheme == null");
        }
        if (map == null) {
            throw new NullPointerException("authParams == null");
        }
        this.scheme = string;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey() == null ? null : entry.getKey().toLowerCase(Locale.US);
            linkedHashMap.put(string2, entry.getValue());
        }
        this.authParams = Collections.unmodifiableMap(linkedHashMap);
    }

    public Challenge(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("scheme == null");
        }
        if (string2 == null) {
            throw new NullPointerException("realm == null");
        }
        this.scheme = string;
        this.authParams = Collections.singletonMap("realm", string2);
    }

    public Challenge withCharset(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset == null");
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.authParams);
        linkedHashMap.put("charset", charset.name());
        return new Challenge(this.scheme, linkedHashMap);
    }

    public String scheme() {
        return this.scheme;
    }

    public Map<String, String> authParams() {
        return this.authParams;
    }

    public String realm() {
        return this.authParams.get("realm");
    }

    public Charset charset() {
        String string = this.authParams.get("charset");
        if (string != null) {
            try {
                return Charset.forName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StandardCharsets.ISO_8859_1;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof Challenge && ((Challenge)object).scheme.equals(this.scheme) && ((Challenge)object).authParams.equals(this.authParams);
    }

    public int hashCode() {
        int n = 29;
        n = 31 * n + this.scheme.hashCode();
        n = 31 * n + this.authParams.hashCode();
        return n;
    }

    public String toString() {
        return this.scheme + " authParams=" + this.authParams;
    }
}

