/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.HttpUrl;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    private final Set<Pin> pins;
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;

    CertificatePinner(Set<Pin> set, @Nullable CertificateChainCleaner certificateChainCleaner) {
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof CertificatePinner && Objects.equals(this.certificateChainCleaner, ((CertificatePinner)object).certificateChainCleaner) && this.pins.equals(((CertificatePinner)object).pins);
    }

    public int hashCode() {
        int n = Objects.hashCode(this.certificateChainCleaner);
        n = 31 * n + this.pins.hashCode();
        return n;
    }

    public void check(String string, List<Certificate> list) throws SSLPeerUnverifiedException {
        Object object;
        List<Pin> list2 = this.findMatchingPins(string);
        if (list2.isEmpty()) {
            return;
        }
        if (this.certificateChainCleaner != null) {
            list = this.certificateChainCleaner.clean(list, string);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            X509Certificate x509Certificate = (X509Certificate)list.get(i);
            object = null;
            ByteString byteString = null;
            int n2 = list2.size();
            for (int j = 0; j < n2; ++j) {
                Pin pin = list2.get(j);
                if (pin.hashAlgorithm.equals("sha256/")) {
                    if (byteString == null) {
                        byteString = CertificatePinner.sha256(x509Certificate);
                    }
                    if (!pin.hash.equals(byteString)) continue;
                    return;
                }
                if (pin.hashAlgorithm.equals("sha1/")) {
                    if (object == null) {
                        object = CertificatePinner.sha1(x509Certificate);
                    }
                    if (!pin.hash.equals(object)) continue;
                    return;
                }
                throw new AssertionError((Object)("unsupported hashAlgorithm: " + pin.hashAlgorithm));
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            object = (X509Certificate)list.get(n);
            stringBuilder.append("\n    ").append(CertificatePinner.pin((Certificate)object)).append(": ").append(((X509Certificate)object).getSubjectDN().getName());
        }
        stringBuilder.append("\n  Pinned certificates for ").append(string).append(":");
        n3 = list2.size();
        for (n = 0; n < n3; ++n) {
            object = list2.get(n);
            stringBuilder.append("\n    ").append(object);
        }
        throw new SSLPeerUnverifiedException(stringBuilder.toString());
    }

    public void check(String string, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string, Arrays.asList(certificateArray));
    }

    List<Pin> findMatchingPins(String string) {
        List<Pin> list = Collections.emptyList();
        for (Pin pin : this.pins) {
            if (!pin.matches(string)) continue;
            if (list.isEmpty()) {
                list = new ArrayList<Pin>();
            }
            list.add(pin);
        }
        return list;
    }

    CertificatePinner withCertificateChainCleaner(@Nullable CertificateChainCleaner certificateChainCleaner) {
        return Objects.equals(this.certificateChainCleaner, certificateChainCleaner) ? this : new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public static String pin(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
        }
        return "sha256/" + CertificatePinner.sha256((X509Certificate)certificate).base64();
    }

    static ByteString sha1(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static ByteString sha256(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha256();
    }

    public static final class Builder {
        private final List<Pin> pins = new ArrayList<Pin>();

        public Builder add(String string, String ... stringArray) {
            if (string == null) {
                throw new NullPointerException("pattern == null");
            }
            for (String string2 : stringArray) {
                this.pins.add(new Pin(string, string2));
            }
            return this;
        }

        public CertificatePinner build() {
            return new CertificatePinner(new LinkedHashSet<Pin>(this.pins), null);
        }
    }

    static final class Pin {
        private static final String WILDCARD = "*.";
        final String pattern;
        final String canonicalHostname;
        final String hashAlgorithm;
        final ByteString hash;

        Pin(String string, String string2) {
            this.pattern = string;
            String string3 = this.canonicalHostname = string.startsWith(WILDCARD) ? HttpUrl.get("http://" + string.substring(WILDCARD.length())).host() : HttpUrl.get("http://" + string).host();
            if (string2.startsWith("sha1/")) {
                this.hashAlgorithm = "sha1/";
                this.hash = ByteString.decodeBase64(string2.substring("sha1/".length()));
            } else if (string2.startsWith("sha256/")) {
                this.hashAlgorithm = "sha256/";
                this.hash = ByteString.decodeBase64(string2.substring("sha256/".length()));
            } else {
                throw new IllegalArgumentException("pins must start with 'sha256/' or 'sha1/': " + string2);
            }
            if (this.hash == null) {
                throw new IllegalArgumentException("pins must be base64: " + string2);
            }
        }

        boolean matches(String string) {
            if (this.pattern.startsWith(WILDCARD)) {
                int n = string.indexOf(46);
                return string.length() - n - 1 == this.canonicalHostname.length() && string.regionMatches(false, n + 1, this.canonicalHostname, 0, this.canonicalHostname.length());
            }
            return string.equals(this.canonicalHostname);
        }

        public boolean equals(Object object) {
            return object instanceof Pin && this.pattern.equals(((Pin)object).pattern) && this.hashAlgorithm.equals(((Pin)object).hashAlgorithm) && this.hash.equals(((Pin)object).hash);
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this.pattern.hashCode();
            n = 31 * n + this.hashAlgorithm.hashCode();
            n = 31 * n + this.hash.hashCode();
            return n;
        }

        public String toString() {
            return this.hashAlgorithm + this.hash.base64();
        }
    }
}

