/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.internal.http.HttpHeaders;

public final class CacheControl {
    public static final CacheControl FORCE_NETWORK = new Builder().noCache().build();
    public static final CacheControl FORCE_CACHE = new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();
    private final boolean noCache;
    private final boolean noStore;
    private final int maxAgeSeconds;
    private final int sMaxAgeSeconds;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean onlyIfCached;
    private final boolean noTransform;
    private final boolean immutable;
    @Nullable
    String headerValue;

    private CacheControl(boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4, boolean bl5, int n3, int n4, boolean bl6, boolean bl7, boolean bl8, @Nullable String string) {
        this.noCache = bl;
        this.noStore = bl2;
        this.maxAgeSeconds = n;
        this.sMaxAgeSeconds = n2;
        this.isPrivate = bl3;
        this.isPublic = bl4;
        this.mustRevalidate = bl5;
        this.maxStaleSeconds = n3;
        this.minFreshSeconds = n4;
        this.onlyIfCached = bl6;
        this.noTransform = bl7;
        this.immutable = bl8;
        this.headerValue = string;
    }

    CacheControl(Builder builder) {
        this.noCache = builder.noCache;
        this.noStore = builder.noStore;
        this.maxAgeSeconds = builder.maxAgeSeconds;
        this.sMaxAgeSeconds = -1;
        this.isPrivate = false;
        this.isPublic = false;
        this.mustRevalidate = false;
        this.maxStaleSeconds = builder.maxStaleSeconds;
        this.minFreshSeconds = builder.minFreshSeconds;
        this.onlyIfCached = builder.onlyIfCached;
        this.noTransform = builder.noTransform;
        this.immutable = builder.immutable;
    }

    public boolean noCache() {
        return this.noCache;
    }

    public boolean noStore() {
        return this.noStore;
    }

    public int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public int sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    public int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public boolean noTransform() {
        return this.noTransform;
    }

    public boolean immutable() {
        return this.immutable;
    }

    public static CacheControl parse(Headers headers) {
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = -1;
        int n4 = -1;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        String string = null;
        int n5 = headers.size();
        for (int i = 0; i < n5; ++i) {
            String string2 = headers.name(i);
            String string3 = headers.value(i);
            if (string2.equalsIgnoreCase("Cache-Control")) {
                if (string != null) {
                    bl9 = false;
                } else {
                    string = string3;
                }
            } else {
                if (!string2.equalsIgnoreCase("Pragma")) continue;
                bl9 = false;
            }
            int n6 = 0;
            while (n6 < string3.length()) {
                String string4;
                int n7 = n6;
                n6 = HttpHeaders.skipUntil(string3, n6, "=,;");
                String string5 = string3.substring(n7, n6).trim();
                if (n6 == string3.length() || string3.charAt(n6) == ',' || string3.charAt(n6) == ';') {
                    ++n6;
                    string4 = null;
                } else {
                    int n8;
                    ++n6;
                    if ((n6 = HttpHeaders.skipWhitespace(string3, n6)) < string3.length() && string3.charAt(n6) == '\"') {
                        n8 = ++n6;
                        n6 = HttpHeaders.skipUntil(string3, n6, "\"");
                        string4 = string3.substring(n8, n6);
                        ++n6;
                    } else {
                        n8 = n6;
                        n6 = HttpHeaders.skipUntil(string3, n6, ",;");
                        string4 = string3.substring(n8, n6).trim();
                    }
                }
                if ("no-cache".equalsIgnoreCase(string5)) {
                    bl = true;
                    continue;
                }
                if ("no-store".equalsIgnoreCase(string5)) {
                    bl2 = true;
                    continue;
                }
                if ("max-age".equalsIgnoreCase(string5)) {
                    n = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("s-maxage".equalsIgnoreCase(string5)) {
                    n2 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("private".equalsIgnoreCase(string5)) {
                    bl3 = true;
                    continue;
                }
                if ("public".equalsIgnoreCase(string5)) {
                    bl4 = true;
                    continue;
                }
                if ("must-revalidate".equalsIgnoreCase(string5)) {
                    bl5 = true;
                    continue;
                }
                if ("max-stale".equalsIgnoreCase(string5)) {
                    n3 = HttpHeaders.parseSeconds(string4, Integer.MAX_VALUE);
                    continue;
                }
                if ("min-fresh".equalsIgnoreCase(string5)) {
                    n4 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("only-if-cached".equalsIgnoreCase(string5)) {
                    bl6 = true;
                    continue;
                }
                if ("no-transform".equalsIgnoreCase(string5)) {
                    bl7 = true;
                    continue;
                }
                if (!"immutable".equalsIgnoreCase(string5)) continue;
                bl8 = true;
            }
        }
        if (!bl9) {
            string = null;
        }
        return new CacheControl(bl, bl2, n, n2, bl3, bl4, bl5, n3, n4, bl6, bl7, bl8, string);
    }

    public String toString() {
        String string = this.headerValue;
        return string != null ? string : (this.headerValue = this.headerValue());
    }

    private String headerValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.noCache) {
            stringBuilder.append("no-cache, ");
        }
        if (this.noStore) {
            stringBuilder.append("no-store, ");
        }
        if (this.maxAgeSeconds != -1) {
            stringBuilder.append("max-age=").append(this.maxAgeSeconds).append(", ");
        }
        if (this.sMaxAgeSeconds != -1) {
            stringBuilder.append("s-maxage=").append(this.sMaxAgeSeconds).append(", ");
        }
        if (this.isPrivate) {
            stringBuilder.append("private, ");
        }
        if (this.isPublic) {
            stringBuilder.append("public, ");
        }
        if (this.mustRevalidate) {
            stringBuilder.append("must-revalidate, ");
        }
        if (this.maxStaleSeconds != -1) {
            stringBuilder.append("max-stale=").append(this.maxStaleSeconds).append(", ");
        }
        if (this.minFreshSeconds != -1) {
            stringBuilder.append("min-fresh=").append(this.minFreshSeconds).append(", ");
        }
        if (this.onlyIfCached) {
            stringBuilder.append("only-if-cached, ");
        }
        if (this.noTransform) {
            stringBuilder.append("no-transform, ");
        }
        if (this.immutable) {
            stringBuilder.append("immutable, ");
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    public static final class Builder {
        boolean noCache;
        boolean noStore;
        int maxAgeSeconds = -1;
        int maxStaleSeconds = -1;
        int minFreshSeconds = -1;
        boolean onlyIfCached;
        boolean noTransform;
        boolean immutable;

        public Builder noCache() {
            this.noCache = true;
            return this;
        }

        public Builder noStore() {
            this.noStore = true;
            return this;
        }

        public Builder maxAge(int n, TimeUnit timeUnit) {
            if (n < 0) {
                throw new IllegalArgumentException("maxAge < 0: " + n);
            }
            long l = timeUnit.toSeconds(n);
            this.maxAgeSeconds = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            return this;
        }

        public Builder maxStale(int n, TimeUnit timeUnit) {
            if (n < 0) {
                throw new IllegalArgumentException("maxStale < 0: " + n);
            }
            long l = timeUnit.toSeconds(n);
            this.maxStaleSeconds = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            return this;
        }

        public Builder minFresh(int n, TimeUnit timeUnit) {
            if (n < 0) {
                throw new IllegalArgumentException("minFresh < 0: " + n);
            }
            long l = timeUnit.toSeconds(n);
            this.minFreshSeconds = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            return this;
        }

        public Builder onlyIfCached() {
            this.onlyIfCached = true;
            return this;
        }

        public Builder noTransform() {
            this.noTransform = true;
            return this;
        }

        public Builder immutable() {
            this.immutable = true;
            return this;
        }

        public CacheControl build() {
            return new CacheControl(this);
        }
    }
}

