/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.cache.InternalCache;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.io.FileSystem;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Cache
implements Closeable,
Flushable {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    final InternalCache internalCache = new InternalCache(){

        @Override
        @Nullable
        public Response get(Request request) throws IOException {
            return Cache.this.get(request);
        }

        @Override
        @Nullable
        public CacheRequest put(Response response) throws IOException {
            return Cache.this.put(response);
        }

        @Override
        public void remove(Request request) throws IOException {
            Cache.this.remove(request);
        }

        @Override
        public void update(Response response, Response response2) {
            Cache.this.update(response, response2);
        }

        @Override
        public void trackConditionalCacheHit() {
            Cache.this.trackConditionalCacheHit();
        }

        @Override
        public void trackResponse(CacheStrategy cacheStrategy) {
            Cache.this.trackResponse(cacheStrategy);
        }
    };
    final DiskLruCache cache;
    int writeSuccessCount;
    int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public Cache(File file, long l) {
        this(file, l, FileSystem.SYSTEM);
    }

    Cache(File file, long l, FileSystem fileSystem) {
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l);
    }

    public static String key(HttpUrl httpUrl) {
        return ByteString.encodeUtf8(httpUrl.toString()).md5().hex();
    }

    @Nullable
    Response get(Request request) {
        Entry entry;
        DiskLruCache.Snapshot snapshot;
        String string = Cache.key(request.url());
        try {
            snapshot = this.cache.get(string);
            if (snapshot == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            entry = new Entry(snapshot.getSource(0));
        }
        catch (IOException iOException) {
            Util.closeQuietly(snapshot);
            return null;
        }
        Response response = entry.response(snapshot);
        if (!entry.matches(request, response)) {
            Util.closeQuietly(response.body());
            return null;
        }
        return response;
    }

    @Nullable
    CacheRequest put(Response response) {
        String string = response.request().method();
        if (HttpMethod.invalidatesCache(response.request().method())) {
            try {
                this.remove(response.request());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (!string.equals("GET")) {
            return null;
        }
        if (HttpHeaders.hasVaryAll(response)) {
            return null;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            editor = this.cache.edit(Cache.key(response.request().url()));
            if (editor == null) {
                return null;
            }
            entry.writeTo(editor);
            return new CacheRequestImpl(editor);
        }
        catch (IOException iOException) {
            this.abortQuietly(editor);
            return null;
        }
    }

    void remove(Request request) throws IOException {
        this.cache.remove(Cache.key(request.url()));
    }

    void update(Response response, Response response2) {
        Entry entry = new Entry(response2);
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)response.body()).snapshot;
        DiskLruCache.Editor editor = null;
        try {
            editor = snapshot.edit();
            if (editor != null) {
                entry.writeTo(editor);
                editor.commit();
            }
        }
        catch (IOException iOException) {
            this.abortQuietly(editor);
        }
    }

    private void abortQuietly(@Nullable DiskLruCache.Editor editor) {
        try {
            if (editor != null) {
                editor.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void initialize() throws IOException {
        this.cache.initialize();
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public Iterator<String> urls() throws IOException {
        return new Iterator<String>(){
            final Iterator<DiskLruCache.Snapshot> delegate;
            @Nullable
            String nextUrl;
            boolean canRemove;
            {
                this.delegate = Cache.this.cache.snapshots();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    try (DiskLruCache.Snapshot snapshot = this.delegate.next();){
                        BufferedSource bufferedSource = Okio.buffer(snapshot.getSource(0));
                        this.nextUrl = bufferedSource.readUtf8LineStrict();
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException iOException) {
                    }
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.nextUrl;
                this.nextUrl = null;
                this.canRemove = true;
                return string;
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException("remove() before next()");
                }
                this.delegate.remove();
            }
        };
    }

    public synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public long size() throws IOException {
        return this.cache.size();
    }

    public long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    public File directory() {
        return this.cache.getDirectory();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    synchronized void trackResponse(CacheStrategy cacheStrategy) {
        ++this.requestCount;
        if (cacheStrategy.networkRequest != null) {
            ++this.networkCount;
        } else if (cacheStrategy.cacheResponse != null) {
            ++this.hitCount;
        }
    }

    synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public synchronized int networkCount() {
        return this.networkCount;
    }

    public synchronized int hitCount() {
        return this.hitCount;
    }

    public synchronized int requestCount() {
        return this.requestCount;
    }

    static int readInt(BufferedSource bufferedSource) throws IOException {
        try {
            long l = bufferedSource.readDecimalLong();
            String string = bufferedSource.readUtf8LineStrict();
            if (l < 0L || l > Integer.MAX_VALUE || !string.isEmpty()) {
                throw new IOException("expected an int but was \"" + l + string + "\"");
            }
            return (int)l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    private static class CacheResponseBody
    extends ResponseBody {
        final DiskLruCache.Snapshot snapshot;
        private final BufferedSource bodySource;
        @Nullable
        private final String contentType;
        @Nullable
        private final String contentLength;

        CacheResponseBody(final DiskLruCache.Snapshot snapshot, String string, String string2) {
            this.snapshot = snapshot;
            this.contentType = string;
            this.contentLength = string2;
            Source source = snapshot.getSource(1);
            this.bodySource = Okio.buffer(new ForwardingSource(source){

                @Override
                public void close() throws IOException {
                    snapshot.close();
                    super.close();
                }
            });
        }

        @Override
        public MediaType contentType() {
            return this.contentType != null ? MediaType.parse(this.contentType) : null;
        }

        @Override
        public long contentLength() {
            try {
                return this.contentLength != null ? Long.parseLong(this.contentLength) : -1L;
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }

        @Override
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    private static final class Entry {
        private static final String SENT_MILLIS = Platform.get().getPrefix() + "-Sent-Millis";
        private static final String RECEIVED_MILLIS = Platform.get().getPrefix() + "-Received-Millis";
        private final String url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final Protocol protocol;
        private final int code;
        private final String message;
        private final Headers responseHeaders;
        @Nullable
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Entry(Source source) throws IOException {
            try {
                BufferedSource bufferedSource = Okio.buffer(source);
                this.url = bufferedSource.readUtf8LineStrict();
                this.requestMethod = bufferedSource.readUtf8LineStrict();
                Headers.Builder builder = new Headers.Builder();
                int n = Cache.readInt(bufferedSource);
                for (int i = 0; i < n; ++i) {
                    builder.addLenient(bufferedSource.readUtf8LineStrict());
                }
                this.varyHeaders = builder.build();
                StatusLine statusLine = StatusLine.parse(bufferedSource.readUtf8LineStrict());
                this.protocol = statusLine.protocol;
                this.code = statusLine.code;
                this.message = statusLine.message;
                Headers.Builder builder2 = new Headers.Builder();
                int n2 = Cache.readInt(bufferedSource);
                for (int i = 0; i < n2; ++i) {
                    builder2.addLenient(bufferedSource.readUtf8LineStrict());
                }
                String string = builder2.get(SENT_MILLIS);
                String string2 = builder2.get(RECEIVED_MILLIS);
                builder2.removeAll(SENT_MILLIS);
                builder2.removeAll(RECEIVED_MILLIS);
                this.sentRequestMillis = string != null ? Long.parseLong(string) : 0L;
                this.receivedResponseMillis = string2 != null ? Long.parseLong(string2) : 0L;
                this.responseHeaders = builder2.build();
                if (this.isHttps()) {
                    String string3 = bufferedSource.readUtf8LineStrict();
                    if (string3.length() > 0) {
                        throw new IOException("expected \"\" but was \"" + string3 + "\"");
                    }
                    String string4 = bufferedSource.readUtf8LineStrict();
                    CipherSuite cipherSuite = CipherSuite.forJavaName(string4);
                    List<Certificate> list = this.readCertificateList(bufferedSource);
                    List<Certificate> list2 = this.readCertificateList(bufferedSource);
                    TlsVersion tlsVersion = !bufferedSource.exhausted() ? TlsVersion.forJavaName(bufferedSource.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                    this.handshake = Handshake.get(tlsVersion, cipherSuite, list, list2);
                } else {
                    this.handshake = null;
                }
            }
            finally {
                source.close();
            }
        }

        Entry(Response response) {
            this.url = response.request().url().toString();
            this.varyHeaders = HttpHeaders.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        public void writeTo(DiskLruCache.Editor editor) throws IOException {
            int n;
            BufferedSink bufferedSink = Okio.buffer(editor.newSink(0));
            bufferedSink.writeUtf8(this.url).writeByte(10);
            bufferedSink.writeUtf8(this.requestMethod).writeByte(10);
            bufferedSink.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
            int n2 = this.varyHeaders.size();
            for (n = 0; n < n2; ++n) {
                bufferedSink.writeUtf8(this.varyHeaders.name(n)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(n)).writeByte(10);
            }
            bufferedSink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
            bufferedSink.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
            n2 = this.responseHeaders.size();
            for (n = 0; n < n2; ++n) {
                bufferedSink.writeUtf8(this.responseHeaders.name(n)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(n)).writeByte(10);
            }
            bufferedSink.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
            bufferedSink.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
            if (this.isHttps()) {
                bufferedSink.writeByte(10);
                bufferedSink.writeUtf8(this.handshake.cipherSuite().javaName()).writeByte(10);
                this.writeCertList(bufferedSink, this.handshake.peerCertificates());
                this.writeCertList(bufferedSink, this.handshake.localCertificates());
                bufferedSink.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
            }
            bufferedSink.close();
        }

        private boolean isHttps() {
            return this.url.startsWith("https://");
        }

        private List<Certificate> readCertificateList(BufferedSource bufferedSource) throws IOException {
            int n = Cache.readInt(bufferedSource);
            if (n == -1) {
                return Collections.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> arrayList = new ArrayList<Certificate>(n);
                for (int i = 0; i < n; ++i) {
                    String string = bufferedSource.readUtf8LineStrict();
                    Buffer buffer = new Buffer();
                    buffer.write(ByteString.decodeBase64(string));
                    arrayList.add(certificateFactory.generateCertificate(buffer.inputStream()));
                }
                return arrayList;
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
        }

        private void writeCertList(BufferedSink bufferedSink, List<Certificate> list) throws IOException {
            try {
                bufferedSink.writeDecimalLong(list.size()).writeByte(10);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    byte[] byArray = list.get(i).getEncoded();
                    String string = ByteString.of(byArray).base64();
                    bufferedSink.writeUtf8(string).writeByte(10);
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException(certificateEncodingException.getMessage());
            }
        }

        public boolean matches(Request request, Response response) {
            return this.url.equals(request.url().toString()) && this.requestMethod.equals(request.method()) && HttpHeaders.varyMatches(response, this.varyHeaders, request);
        }

        public Response response(DiskLruCache.Snapshot snapshot) {
            String string = this.responseHeaders.get("Content-Type");
            String string2 = this.responseHeaders.get("Content-Length");
            Request request = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, string, string2)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }
    }

    private final class CacheRequestImpl
    implements CacheRequest {
        private final DiskLruCache.Editor editor;
        private Sink cacheOut;
        private Sink body;
        boolean done;

        CacheRequestImpl(final DiskLruCache.Editor editor) {
            this.editor = editor;
            this.cacheOut = editor.newSink(1);
            this.body = new ForwardingSink(this.cacheOut){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    synchronized (cache) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.this.done = true;
                        ++Cache.this.writeSuccessCount;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            Cache cache = Cache.this;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                ++Cache.this.writeAbortCount;
            }
            Util.closeQuietly(this.cacheOut);
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public Sink body() {
            return this.body;
        }
    }
}

